<?php

namespace emberware\vendia\groups\common\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use emberware\vendia\groups\common\models\Product;

/**
 * ProductSearch represents the model behind the search form of `emberware\vendia\groups\common\models\Product`.
 */
class ProductSearch extends Product
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'product_wc_id', 'producer_wc_id'], 'integer'],
            [['title', 'selling_unit', 'sku', 'weight', 'sorting_code', 'selling_quantity'], 'safe'],
            [['price'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Product::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'product_wc_id' => $this->product_wc_id,
            'price' => $this->price,
            'producer_wc_id' => $this->producer_wc_id,
        ]);

        $query->andFilterWhere(['like', 'title', $this->title])
            ->andFilterWhere(['like', 'selling_unit', $this->selling_unit])
            ->andFilterWhere(['like', 'sku', $this->sku])
            ->andFilterWhere(['like', 'weight', $this->weight])
            ->andFilterWhere(['like', 'sorting_code', $this->sorting_code])
            ->andFilterWhere(['like', 'selling_quantity', $this->selling_quantity]);

        return $dataProvider;
    }
}
