<?php

namespace emberware\vendia\groups\common\models;

use Yii;
use emberware\vendia\arrivi\common\models\WcClient;

class WcCustomer extends WcClient
{

    /**
     * Singlo ordine
     */
    public function findCustomer($id){
        return $this->get('customers/'.$id);
    }

    /**
     * Lista di tutti gli customer
     */
    public function findCustomers($page){
        return $this->get('customers?per_page=100&page='.$page);
    }


    public function findAllCustomers(){

        $page = 1;
        $arrCustomers = array();

        $customers = $this->findCustomers($page);

        while(!empty($customers)){
            foreach($customers as $customer){
                array_push($arrCustomers, $customer);
            }
            $page++;   
            $customers = $this->findCustomers($page);        
        }

        return $arrCustomers;
    }

     /**
     * Lista dei customer dopo la ricerca
    */
    public function findSearchedCustomer($search){
        return $this->get('customer?per_page=100&orderby=title&order=asc&search='.$search);
    }

}