<?php

namespace emberware\vendia\modalita\vendita\common\models;

use Yii;


/**
 * This is the model class for table "producer".
 *
 * @property int $id
 * @property int|null $producer_wp_id
 * @property string|null $name
 * @property string|null $enabled
 * @property string|null $status
 * @property string|null $created_at
 * @property string|null $updated_at
 */
class Producer extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'producer';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['producer_wp_id'], 'integer'],
            [['name', 'enabled', 'status', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'producer_wp_id' => 'Producer Wp ID',
            'name' => 'Nome',
            'enabled' => 'Abilitato',
            'status' => 'Status',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }

    public function findProducerByWPId($id){

         $producer =  Producer::find()
            ->select('*')
            ->where("producer_wp_id = '".$id."'")
            ->one();

        return $producer;
    }

    public function findAllProducer(){
        $producers =  Producer::find()
                                ->orderBy(['name' => SORT_ASC])
                                ->all();

        return $producers;
    }

    public function findEnabledProducer(){

        $listEnabled = array();
        $producers =  Producer::find()
                                ->select('producer_wp_id')
                                ->where(['enabled' => "true"])
                                ->orderBy(['name' => SORT_ASC])
                                ->all();

        foreach($producers as $producer){
            array_push($listEnabled, $producer->producer_wp_id);
        }

        return $listEnabled;
    }
    public function findDisabledProducer(){

        $listDisabled = array();
        $producers =  Producer::find()
                                ->select('producer_wp_id')
                                ->where(['enabled' => "false"])
                                ->orderBy(['name' => SORT_ASC])
                                ->all();

        foreach($producers as $producer){
            array_push($listDisabled, $producer->producer_wp_id);
        }

        return $listDisabled;
    }
}
