<?php
use yii\widgets\Breadcrumbs;
use yii\helpers\Html;
use emberware\vendia\modalita\vendita\backend\Asset;
use emberware\vendia\modalita\vendita\common\models\Producer;

emberware\vendia\modalita\vendita\backend\Asset::register($this);
/* @var $this yii\web\View */
/* @var $searchModel backend\models\GuestSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */
if(!empty($sales_mode)){
    $sales_mode = $sales_mode->value;
} else{
    $sales_mode = "";
}
?>
<div class="sales-mode-index">
    <div class="row">
        <div class="col-md-12">
            <h3>Gestione modalità di vendita</h3>
        </div>
    </div>
    <form method="post" action="select-producers" id="producer-form">
        <div class="form-group">
            <div class="row">
                <div class="col-lg-4 col-md-6 col-sm-10 col-xs-10">
                    <select id="select-sales-mode" class="form-control" name="sales-mode">
                        <option value="">Seleziona la modalità di vendita</option>
                        <option value="all" <?=($sales_mode == "all")? "selected": ""?>>Tutti i prodotti</option>
                        <option value="all-selected" <?=($sales_mode == "all-selected")? "selected": ""?>>Tutti i prodotti delle aziende selezionate</option>
                        <option value="all-except" <?=($sales_mode == "all-except")? "selected": ""?>>Tutti i prodotti delle aziende non selezionate</option>
                        <option value="none" <?=($sales_mode == "none")? "selected": ""?>>Nessun prodotto</option>
                    </select>
                </div>
            </div>
            <br><br>
            <div class="row">
                <div class="col-lg-8 col-md-6 col-sm-10 col-xs-10">
                    <div class="producer" <?=($sales_mode == "all" || $sales_mode == "none")? "style='display:none'": "style='display:block'"?>>
                        <?php
                            $producer = new Producer();
                            $listProducer = $producer->findAllProducer();
                        ?>
                        <div class="row">
                            <div class="col-xs-5">
                                <select name="from[]" id="search" class="form-control" size="8" multiple="multiple">
                                <?php
                                foreach($listProducer as $producerSingle){
                                    if(!in_array($producerSingle->danea_code, $listProducersTo)){
                                ?>
                                    <option value="<?=$producerSingle->danea_code?>" ><?=$producerSingle->name?></option>
                                <?php
                                    }
                                }
                                ?>
                                </select>
                            </div>
                            <div class="col-xs-2">
                                <button type="button" id="search_rightAll" class="btn btn-block btn-primary"><i class="glyphicon glyphicon-forward"></i></button>
                                <button type="button" id="search_rightSelected" class="btn btn-block btn-success"><i class="glyphicon glyphicon-chevron-right"></i></button>
                                <button type="button" id="search_leftSelected" class="btn btn-block btn-danger"><i class="glyphicon glyphicon-chevron-left"></i></button>
                                <button type="button" id="search_leftAll" class="btn btn-block btn-primary"><i class="glyphicon glyphicon-backward"></i></button>
                            </div>
                            
                            <div class="col-xs-5">
                                <select name="to[]" id="search_to" class="form-control" size="8" multiple="multiple">
                                <?php
                                foreach($listProducer as $producerSingle){
                                    if(in_array($producerSingle->danea_code, $listProducersTo)){
                                ?>
                                <option value="<?=$producerSingle->danea_code?>" ><?=$producerSingle->name?></option>
                                <?php      
                                    }
                                }
                                ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <button type="submit" id="submit-producers" class="btn btn-primary">Salva</button>
                </div>
            </div>
        </div>
    </form>
</div>
