<?php

namespace emberware\vendia\modalita\vendita\backend\controllers;

use Yii;
use yii\web\Controller;
use emberware\vendia\modalita\vendita\common\models\WcProducer;
use emberware\vendia\modalita\vendita\common\models\WcOption;
use emberware\vendia\modalita\vendita\common\models\Producer;
use emberware\evidia\options\common\models\Option;
use yii\data\ActiveDataProvider;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;
use yii\helpers\Html;

class ProducerController extends Controller
{

    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    public function actionIndex()
    {
        $model = new Producer();

        $pageSize = 10;
        $dataProvider = new ActiveDataProvider([
            'query' => Producer::find()->orderBy('name'),
            'pagination' => [
                'pageSize' => 10,
            ],
        ]);


        $columns =  [
                        ['class' => '\yii\grid\SerialColumn'],
                        [

                            'attribute' => 'name',
                            'format'=>'raw',
                            'value' => function($data){
                                return utf8_encode ($data->name);
                            }
                        ],
                        [

                            'attribute' => 'enabled',
                            'format'=>'raw',
                            'value' => function($data){
                                if($data->enabled == "true"){
                                    return Html::tag('span', $data->enabled, ['class' => 'label label-success']);
                                }
                                if($data->enabled == "false"){
                                    return Html::tag('span', $data->enabled, ['class' => 'label label-danger']);
                                }
                            }
                        ],
                        // [
                        //     'format'=>'raw',
                        //     'label' => 'Azioni',
                        //     'value' => function($data)
                        //     {return Html::button("<i class='fa fa-trash-o'></i>", ['class'=>'modal-delete-user button-link', 'value'=>$data->id]);}
                        // ],
                    ];

        return $this->render('index', [
            'model' => $model,
            'dataProvider' => $dataProvider,
            'columns' => $columns,
            'pageSize' => $pageSize
        ]);
    }

    public function actionImportProducers(){


        $producer = new Producer();

        $result = $producer->saveImportProducers();

        if($result){
            $response = Yii::$app->response;
            $response->format = \yii\web\Response::FORMAT_JSON;
            $response->data = true;
            $response->statusCode = 200;
        }else{
            $response->data = false;
        }

        return $response;
    }

    public function actionManageSalesMode()
    {
        $listProducerEnabled = array();
        $option = new Option();
        $salesMode = $option->findSlug('modalita-di-vendita');

        if(isset($salesMode)){
            $salesMode = $salesMode->value;
        }else{
            $salesMode = "";
        }
        $producer = new Producer();
        $enabledProducer = $producer->findEnabledProducer();

        $allProducer = $producer->findAllProducer();

        foreach($allProducer as $producerSingle){
            if(in_array($producerSingle->danea_code, $enabledProducer)){
                array_push($listProducerEnabled, $producerSingle->danea_code);
            }
        }

        return $this->render('manage-sales-mode', [
            'sales_mode' => $salesMode,
            'listProducersTo' => $listProducerEnabled
        ]);
    }

    public function actionSelectProducers()
    {
        $arrProducer = array();
        $result = false;
        $request = Yii::$app->request->post();
        $option = new Option();

        $salesMode = $request['sales-mode'];

        //salvo nelle opzioni il valore della modalità di vendita
        $option = $option->findSlug('modalita-di-vendita');
        if(empty($option)){
            $option = new Option();
            $option->name = 'Modalità di vendita';
            $option->type = 'text';
            $option->value = $request['sales-mode'];
            $option->slug = 'modalita-di-vendita';
            $option->status = Yii::$app->params['active'];
            $option->id_user_ins = Yii::$app->user->id;
            $option->id_user_upd = Yii::$app->user->id;
            $option->date_ins = time();
            $option->date_upd = time();
        }else{
            $option->value = $request['sales-mode'];
            $option->id_user_upd = Yii::$app->user->id;
            $option->date_upd = time();
        }

        $result = $option->save();

        if(isset($request['to'])){
            $producer = new Producer();
            $allProducer = $producer->findAllProducer();
            //inserisco tutte le selezionate
            if($salesMode == "all-selected"){
                $producersSelectedTo = $request['to'];
                foreach($allProducer as $producerSingle){
                    $producer = new Producer();
                    $producer = $producer->findProducerByWPId($producerSingle->producer_wp_id);
                    if(in_array($producerSingle->danea_code, $producersSelectedTo)){
                        $producer->enabled = "true";
                        $producer->updated_at = time();
                    }else{
                        $producer->enabled = "false";
                        $producer->updated_at = time();
                    }
                    $result = $producer->save(false);
                }
            }

            //inserisco le non selezionate
            if($salesMode == "all-except"){
                $producersSelectedFrom = $request['from'];
                foreach($allProducer as $producerSingle){
                    $producer = new Producer();
                    $producer = $producer->findProducerByWPId($producerSingle->producer_wp_id);
                    if(in_array($producerSingle->danea_code, $producersSelectedFrom)){
                        $producer->enabled = "false";
                        $producer->updated_at = time();
                    }else{
                        $producer->enabled = "true";
                        $producer->updated_at = time();
                    }
                    $result = $producer->save(false);
                }
            }
        }

        if($result){
            $producer = new Producer();

            switch($salesMode){
                case "all":
                    $listProducer = $producer->findAllProducer();
                    foreach($listProducer as $prodElement){
                        array_push($arrProducer, $prodElement['danea_code']);
                    }
                    break;
                case "all-selected":
                    $listProducer = $producer->findEnabledProducer();
                    $arrProducer = $listProducer;
                    break;
                case "all-except":
                    $listProducer = $producer->findDisabledProducer();
                    $arrProducer = $listProducer;
                    break;
                case "none":
                    $arrProducer = array();
                    break;
            }

            $option = new WcOption();
            $result = $option->sendProducer(json_encode($arrProducer));
        }

        if($result){
            $response = Yii::$app->response;
            $response->format = \yii\web\Response::FORMAT_JSON;
            $response->data = $result;
            $response->statusCode = 200;
        }else{
            $response->data = false;
        }

        return $response;

    }
}
