<?php

namespace emberware\vendia\modalita\vendita\common\models;

use Yii;


/**
 * This is the model class for table "producer".
 *
 * @property int $id
 * @property int|null $producer_wp_id
 * @property string|null $name
 * @property string|null $enabled
 * @property string|null $status
 * @property string|null $created_at
 * @property string|null $updated_at
 */
class Producer extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'producer';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['producer_wp_id'], 'integer'],
            [['name', 'enabled', 'status', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'producer_wp_id' => 'Producer Wp ID',
            'name' => 'Nome',
            'enabled' => 'Abilitato',
            'status' => 'Status',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }

    public function findProducerByWPId($id){

         $producer =  Producer::find()
            ->select('*')
            ->where("producer_wp_id = '".$id."'")
            ->one();

        return $producer;
    }

    public function findAllProducer(){
        $producers =  Producer::find()
                                ->orderBy(['name' => SORT_ASC])
                                ->all();

        return $producers;
    }

    public function findEnabledProducer(){

        $listEnabled = array();
        $producers =  Producer::find()
                                ->select('danea_code')
                                ->where(['enabled' => "true"])
                                ->orderBy(['name' => SORT_ASC])
                                ->all();

        foreach($producers as $producer){
            array_push($listEnabled, $producer->danea_code);
        }

        return $listEnabled;
    }
    public function findDisabledProducer(){

        $listDisabled = array();
        $producers =  Producer::find()
                                ->select('danea_code')
                                ->where(['enabled' => "false"])
                                ->orderBy(['name' => SORT_ASC])
                                ->all();

        foreach($producers as $producer){
            array_push($listDisabled, $producer->danea_code);
        }

        return $listDisabled;
    }

    public function saveImportProducers(){

        $result = false;
        $wcProducer = new WcProducer();
        $producer = new Producer();

        $producersList = $wcProducer->findAllProducers();

       // print_r($producersList);
        foreach($producersList as $wcProducer){
            $producer = $this->findProducerByWPId($wcProducer->id);
            if(empty($producer)){
                $producer = new Producer();

                $producer->producer_wp_id = $wcProducer->id;
                $producer->name = $wcProducer->title->rendered;

                $wcDaneaCode = $wcProducer->meta->codice_danea;
                $daneaCode = $wcDaneaCode['0'];

                $producer->danea_code = $daneaCode;
                $producer->enabled = "false";
                $producer->status = Yii::$app->params['active'];
                $producer->created_at = time();
                $producer->updated_at = time();
            }else{
                $wcDaneaCode = $wcProducer->meta->codice_danea;
                $daneaCode = $wcDaneaCode['0'];
                $producer->danea_code = $daneaCode;
                $producer->name = $wcProducer->title->rendered;
                $producer->updated_at = time();
            }

            $result = $producer->save(false);
        }

        return $result;
    }
}
