<?php

namespace emberware\vendia\modalita\vendita\backend\controllers;

use Yii;
use yii\web\Controller;
use emberware\vendia\modalita\vendita\common\models\WcProducer;
use emberware\vendia\modalita\vendita\common\models\WcOption;
use emberware\vendia\modalita\vendita\common\models\Producer;
use emberware\evidia\options\common\models\Option;
use yii\data\ActiveDataProvider;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;
use yii\helpers\Html;

class ProducerController extends Controller
{

    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    public function actionIndex()
    {
        $model = new Producer();

        $pageSize = 10;
        $dataProvider = new ActiveDataProvider([
            'query' => Producer::find()->orderBy('name'),
            'pagination' => [
                'pageSize' => 10,
            ],
        ]);


        $columns =  [
                        ['class' => '\yii\grid\SerialColumn'],
                        [

                            'attribute' => 'name',
                            'format'=>'raw',
                            'value' => function($data){
                                return utf8_encode ($data->name);
                            }
                        ],
                        [

                            'attribute' => 'enabled',
                            'format'=>'raw',
                            'value' => function($data){
                                if($data->enabled == "true"){
                                    return Html::tag('span', $data->enabled, ['class' => 'label label-success']);
                                }
                                if($data->enabled == "false"){
                                    return Html::tag('span', $data->enabled, ['class' => 'label label-danger']);
                                }
                            }
                        ],
                        // [
                        //     'format'=>'raw',
                        //     'label' => 'Azioni',
                        //     'value' => function($data)
                        //     {return Html::button("<i class='fa fa-trash-o'></i>", ['class'=>'modal-delete-user button-link', 'value'=>$data->id]);}
                        // ],
                    ];

        return $this->render('index', [
            'model' => $model,
            'dataProvider' => $dataProvider,
            'columns' => $columns,
            'pageSize' => $pageSize
        ]);
    }

    public function actionImportProducers(){


        $producer = new Producer();

        $result = $producer->saveImportProducers();

        if($result){
            $response = Yii::$app->response;
            $response->format = \yii\web\Response::FORMAT_JSON;
            $response->data = true;
            $response->statusCode = 200;
        }else{
            $response->data = false;
        }

        return $response;
    }

    public function actionManageSalesMode()
    {
        $listProducerEnabled = array();
        $option = new Option();
        $salesMode = $option->findSlug('modalita-di-vendita');

        if(isset($salesMode)){
            $salesMode = $salesMode->value;
        }else{
            $salesMode = "";
        }
        $producer = new Producer();
        $enabledProducer = $producer->findEnabledProducer();

        $allProducer = $producer->findAllProducer();

        foreach($allProducer as $producerSingle){
            if(in_array($producerSingle->danea_code, $enabledProducer)){
                array_push($listProducerEnabled, $producerSingle->danea_code);
            }
        }

        return $this->render('manage-sales-mode', [
            'sales_mode' => $salesMode,
            'listProducersTo' => $listProducerEnabled
        ]);
    }

    public function actionSelectProducers()
    {
        $arrProducer = array();
        
        $request = Yii::$app->request->post();
        $salesMode = $request['sales-mode'];

        Producer::updateSalesMode($salesMode);
        $producers = Producer::setProducers($request, $salesMode);
        $result = Producer::updateListProducer($producers);
    
        return $this->redirect('manage-sales-mode');
    }

}
