<?php

namespace emberware\vendia\modalita\vendita\common\models;

use Yii;
use emberware\vendia\modalita\vendita\common\models\WcProducer;
use emberware\vendia\modalita\vendita\common\models\WcOption;
use emberware\evidia\options\common\models\Option;

/**
 * This is the model class for table "producer".
 *
 * @property int $id
 * @property int|null $producer_wp_id
 * @property string|null $name
 * @property string|null $enabled
 * @property string|null $status
 * @property string|null $created_at
 * @property string|null $updated_at
 */
class Producer extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'producer';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['producer_wp_id'], 'integer'],
            [['name', 'enabled', 'status', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'producer_wp_id' => 'Producer Wp ID',
            'name' => 'Nome',
            'enabled' => 'Abilitato',
            'status' => 'Status',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }

    public function findProducerByWPId($id){

         $producer =  Producer::find()
            ->select('*')
            ->where("producer_wp_id = '".$id."'")
            ->one();

        return $producer;
    }

    public function findAllProducer(){
        $producers =  Producer::find()
                                ->orderBy(['name' => SORT_ASC])
                                ->all();

        return $producers;
    }

    public function findEnabledProducer(){

        $listEnabled = array();
        $producers =  Producer::find()
                                ->select('danea_code')
                                ->where(['enabled' => "true"])
                                ->orderBy(['name' => SORT_ASC])
                                ->all();

        foreach($producers as $producer){
            array_push($listEnabled, $producer->danea_code);
        }

        return $listEnabled;
    }
    public function findDisabledProducer(){

        $listDisabled = array();
        $producers =  Producer::find()
                                ->select('danea_code')
                                ->where(['enabled' => "false"])
                                ->orderBy(['name' => SORT_ASC])
                                ->all();

        foreach($producers as $producer){
            array_push($listDisabled, $producer->danea_code);
        }

        return $listDisabled;
    }

    public function saveImportProducers(){

        $result = false;
        $wcProducer = new WcProducer();
        $producer = new Producer();

        $producersList = $wcProducer->findAllProducers();

       // print_r($producersList);
        foreach($producersList as $wcProducer){
            $producer = $this->findProducerByWPId($wcProducer->id);
            if(empty($producer)){
                $producer = new Producer();
                $producer->producer_wp_id = $wcProducer->id;
                $producer->name = $wcProducer->title->rendered;
                $wcDaneaCode = $wcProducer->meta->codice_danea;
                $daneaCode = $wcDaneaCode['0'];
                $producer->danea_code = $daneaCode;
                $producer->enabled = "false";
                $producer->status = Yii::$app->params['active'];
                $producer->created_at = time();
                $producer->updated_at = time();
            }else{
                $wcDaneaCode = $wcProducer->meta->codice_danea;
                $daneaCode = $wcDaneaCode['0'];
                $producer->danea_code = $daneaCode;
                $producer->name = $wcProducer->title->rendered;
                $producer->updated_at = time();
            }

            $result = $producer->save(false);
        }

        return $result;
    }

   

    public static function updateSalesMode($salesMode){
        $option = new Option();
        //salvo nelle opzioni il valore della modalità di vendita
        $option = $option->findSlug('modalita-di-vendita');
        if(empty($option)){
            $option = new Option();
            $option->name = 'Modalità di vendita';
            $option->type = 'text';
            $option->value = $salesMode;
            $option->slug = 'modalita-di-vendita';
            $option->status = Yii::$app->params['active'];
            $option->id_user_ins = Yii::$app->user->id;
            $option->id_user_upd = Yii::$app->user->id;
            $option->date_ins = time();
            $option->date_upd = time();
        }else{
            $option->value = $salesMode;
            $option->id_user_upd = Yii::$app->user->id;
            $option->date_upd = time();
        }

        $option->save();
    }

        
    public static function setProducers($producerSelected, $salesMode){
               
        $producer = new Producer();
        $allProducer = $producer->findAllProducer();
       
        //inserisco tutte le selezionate
        if($salesMode == "all-selected"){
            if(!empty($producerSelected['to'])){
                $producersSelectedTo = $producerSelected['to'];
            }else{
                $producersSelectedTo = array();
            }
            
            foreach($allProducer as $producerSingle){
                $producer = new Producer();
                $producer = $producer->findProducerByWPId($producerSingle->producer_wp_id);
                if(in_array($producerSingle->danea_code, $producersSelectedTo)){
                    $producer->enabled = "true";
                    $producer->updated_at = time();
                }else{
                    $producer->enabled = "false";
                    $producer->updated_at = time();
                }
                $producer->save(false);
            }
        }

        //inserisco le non selezionate
        if($salesMode == "all-except"){
            if(!empty($producerSelected['from'])){
                $producersSelectedFrom = $producerSelected['from'];
            }else{
                $producersSelectedFrom = array();
            }
            foreach($allProducer as $producerSingle){
                $producer = new Producer();
                $producer = $producer->findProducerByWPId($producerSingle->producer_wp_id);
                if(in_array($producerSingle->danea_code, $producersSelectedFrom)){
                    $producer->enabled = "false";
                    $producer->updated_at = time();
                }else{
                    $producer->enabled = "true";
                    $producer->updated_at = time();
                }
                $producer->save(false);
            }
        }

        switch($salesMode){
            case "all":
                $listProducer = $producer->findAllProducer();
                foreach($listProducer as $prodElement){
                    array_push($arrProducer, $prodElement['danea_code']);
                }
                break;
            case "all-selected":
                $listProducer = $producer->findEnabledProducer();
                $arrProducer = $listProducer;
                break;
            case "all-except":
                $listProducer = $producer->findDisabledProducer();
                $arrProducer = $listProducer;
                break;
            case "none":
                $arrProducer = array();
                break;
        }

        return $arrProducer;
    }

    public static function updateListProducer($producers){
        $optionParam = "producer-list";
        $option = new WcOption();
        $result = $option->setOptionParam(json_encode($producers), $optionParam);

        return $result;
    }


}
