<?php

namespace emberware\vendia\modalita\vendita\common\models;

use Yii;
use Automattic\WooCommerce\Client;

class WcClientWp extends \yii\base\Model
{

    protected $url;
    protected $ck;
    protected $cs;

    public function __construct(){
        $this->url  = Yii::$app->params['wc_url'];
        $this->ck = Yii::$app->params['wc_ck'];
        $this->cs = Yii::$app->params['wc_cs'];
    }

    public function get($command){
        $client = new Client(
            $this->url, 
            $this->ck, 
            $this->cs,
            [
                'wp_api' => 'true', // Enable the WP REST API integration
                'version' => 'wp/v2',
                'query_string_auth' => 'true',
            ]
        );
        
        return $client->get($command);
    }

    public function put($command, $data){
        $client = new Client(
            $this->url, 
            $this->ck, 
            $this->cs,
            [
                'version' => 'wp/v2',
                'query_string_auth' => 'true',
            ]
        );
        
        return $client->put($command, $data);
    }
    
}