<?php
/**
 * @package Vendia-Consumption
 * @version 1.0
 */
/*
Plugin Name: Vendia consumazioni
Plugin URI: http://vendia.it/
Description: This plugin allows to manage food and goods consumption.
Author: Emberware
Version: 1.0
Author URI: http://emberware.it/
*/

add_action( 'init', 'register_good');

// Register goods (consumazioni)
register_good();
function register_good() {
	$labels = array(
		'name'                  => _x( 'Consumazioni', 'Post Type General Name', 'vendia' ),
		'singular_name'         => _x( 'Consumazione', 'Post Type Singular Name', 'vendia' ),
    'menu_name'             => __( 'Consumazioni', 'vendia' ),
		'name_admin_bar'        => __( 'Consumazioni', 'vendia' ),
		// 'archives'              => __( 'Item Archives', 'vendia' ),
		// 'parent_item_colon'     => __( 'Parent Item:', 'vendia' ),
		'all_items'             => __( 'Tutti', 'vendia' ),
		'add_new_item'          => __( 'Aggiungi Nuova', 'vendia' ),
		'add_new'               => __( 'Aggiungi Nuova', 'vendia' ),
		'new_item'              => __( 'Nuova', 'vendia' ),
		'edit_item'             => __( 'Modifica', 'vendia' ),
		'update_item'           => __( 'Aggiorna', 'vendia' ),
		'view_item'             => __( 'Visualizza', 'vendia' ),
		// 'search_items'          => __( 'Search Item', 'vendia' ),
		'not_found'             => __( 'Non trovata', 'vendia' ),
		'not_found_in_trash'    => __( 'Non trovata nel cestino', 'vendia' ),
		// 'featured_image'        => __( 'Featured Image', 'vendia' ),
		// 'set_featured_image'    => __( 'Set featured image', 'vendia' ),
		// 'remove_featured_image' => __( 'Remove featured image', 'vendia' ),
		// 'use_featured_image'    => __( 'Use as featured image', 'vendia' ),
		// 'insert_into_item'      => __( 'Insert into item', 'vendia' ),
		// 'uploaded_to_this_item' => __( 'Uploaded to this item', 'vendia' ),
		// 'items_list'            => __( 'Items list', 'vendia' ),
		// 'items_list_navigation' => __( 'Items list navigation', 'vendia' ),
		// 'filter_items_list'     => __( 'Filter items list', 'vendia' ),
	);
	$args = array(
		'label'                 => __( 'Consumazioni', 'vendia' ),
		'description'           => __( 'Consumazioni', 'vendia' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'author', ),
		// 'taxonomies'            => array( 'post_tag' ),
		'hierarchical'          => false,
		'public'                => false,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'menu_icon'             => 'dashicons-carrot',
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => false,
		'exclude_from_search'   => true,
		'publicly_queryable'    => false,
		'rewrite'               => false,
		'capability_type'       => 'post',
	);
	register_post_type( 'vnd_good', $args );

}

// Register checkin
register_checkin();
function register_checkin() {
	$labels = array(
		'name'                  => _x( 'Checkin', 'Post Type General Name', 'vendia' ),
		'singular_name'         => _x( 'Checkin', 'Post Type Singular Name', 'vendia' ),
    'menu_name'             => __( 'Checkin', 'vendia' ),
		'name_admin_bar'        => __( 'Checkin', 'vendia' ),
		// 'archives'              => __( 'Item Archives', 'vendia' ),
		// 'parent_item_colon'     => __( 'Parent Item:', 'vendia' ),
		'all_items'             => __( 'Tutti', 'vendia' ),
		'add_new_item'          => __( 'Aggiungi Nuova', 'vendia' ),
		'add_new'               => __( 'Aggiungi Nuova', 'vendia' ),
		'new_item'              => __( 'Nuova', 'vendia' ),
		'edit_item'             => __( 'Modifica', 'vendia' ),
		'update_item'           => __( 'Aggiorna', 'vendia' ),
		'view_item'             => __( 'Visualizza', 'vendia' ),
		// 'search_items'          => __( 'Search Item', 'vendia' ),
		'not_found'             => __( 'Non trovata', 'vendia' ),
		'not_found_in_trash'    => __( 'Non trovata nel cestino', 'vendia' ),
		// 'featured_image'        => __( 'Featured Image', 'vendia' ),
		// 'set_featured_image'    => __( 'Set featured image', 'vendia' ),
		// 'remove_featured_image' => __( 'Remove featured image', 'vendia' ),
		// 'use_featured_image'    => __( 'Use as featured image', 'vendia' ),
		// 'insert_into_item'      => __( 'Insert into item', 'vendia' ),
		// 'uploaded_to_this_item' => __( 'Uploaded to this item', 'vendia' ),
		// 'items_list'            => __( 'Items list', 'vendia' ),
		// 'items_list_navigation' => __( 'Items list navigation', 'vendia' ),
		// 'filter_items_list'     => __( 'Filter items list', 'vendia' ),
	);
	$args = array(
		'label'                 => __( 'Checkin', 'vendia' ),
		'description'           => __( 'Checkin', 'vendia' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'author', ),
		// 'taxonomies'            => array( 'post_tag' ),
		'hierarchical'          => false,
		'public'                => false,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'menu_icon'             => 'dashicons-list-view',
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => false,
		'exclude_from_search'   => true,
		'publicly_queryable'    => false,
		'rewrite'               => false,
		'capability_type'       => 'post',
	);
	register_post_type( 'vnd_checkin', $args );
}

// Register locations
register_locations();
function register_locations() {
	$labels = array(
		'name'                  => _x( 'Postazioni', 'Post Type General Name', 'vendia' ),
		'singular_name'         => _x( 'Postazione', 'Post Type Singular Name', 'vendia' ),
    'menu_name'             => __( 'Postazioni', 'vendia' ),
		'name_admin_bar'        => __( 'Postazioni', 'vendia' ),
		// 'archives'              => __( 'Item Archives', 'vendia' ),
		// 'parent_item_colon'     => __( 'Parent Item:', 'vendia' ),
		'all_items'             => __( 'Tutti', 'vendia' ),
		'add_new_item'          => __( 'Aggiungi Nuova', 'vendia' ),
		'add_new'               => __( 'Aggiungi Nuova', 'vendia' ),
		'new_item'              => __( 'Nuova', 'vendia' ),
		'edit_item'             => __( 'Modifica', 'vendia' ),
		'update_item'           => __( 'Aggiorna', 'vendia' ),
		'view_item'             => __( 'Visualizza', 'vendia' ),
		// 'search_items'          => __( 'Search Item', 'vendia' ),
		'not_found'             => __( 'Non trovata', 'vendia' ),
		'not_found_in_trash'    => __( 'Non trovata nel cestino', 'vendia' ),
		// 'featured_image'        => __( 'Featured Image', 'vendia' ),
		// 'set_featured_image'    => __( 'Set featured image', 'vendia' ),
		// 'remove_featured_image' => __( 'Remove featured image', 'vendia' ),
		// 'use_featured_image'    => __( 'Use as featured image', 'vendia' ),
		// 'insert_into_item'      => __( 'Insert into item', 'vendia' ),
		// 'uploaded_to_this_item' => __( 'Uploaded to this item', 'vendia' ),
		// 'items_list'            => __( 'Items list', 'vendia' ),
		// 'items_list_navigation' => __( 'Items list navigation', 'vendia' ),
		// 'filter_items_list'     => __( 'Filter items list', 'vendia' ),
	);
	$args = array(
		'label'                 => __( 'Postazioni', 'vendia' ),
		'description'           => __( 'Postazioni', 'vendia' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'author', 'thumbnail', ),
		// 'taxonomies'            => array( 'post_tag' ),
		'hierarchical'          => false,
		'public'                => false,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'menu_icon'             => 'dashicons-location',
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => false,
		'exclude_from_search'   => true,
		'publicly_queryable'    => false,
		'rewrite'               => false,
		'capability_type'       => 'post',
	);
	register_post_type( 'vnd_location', $args );
}

add_shortcode('vendia_id_checkin', 'vendia_id_checkin');
function vendia_id_checkin($atts){
  $atts = shortcode_atts( array(
    'location' => 1,
	), $atts, 'vendia_id_checkin' );
  $location = $atts['location'];
  add_action( 'wp_enqueue_scripts', 'rest_vendia_scripts', 999 );
  wp_localize_script( 'vendiajs', 'rest_object',
      array(
          'location_id'   => site_url('/wp-json/rest/v1/'),
      )
  );
  ob_start();
  include( plugin_dir_path ( __FILE__ ).'public/partials/vendia-id-checkin.php');
  return ob_get_clean();
}

// add_action( 'wp_enqueue_scripts', 'rest_vendia_scripts', 999 );
function rest_vendia_scripts() {
    // Enqueue our JS file
    wp_enqueue_script( 'vendiajs',
      get_template_directory_uri() . '/public/js/vendia.js',
      array( 'jquery' ), filemtime( get_template_directory() . '/js/app.js'), true
    );

    // Provide a global object to our JS file contaning our REST API endpoint, and API nonce
    // Nonce must be 'wp_rest' !
    wp_localize_script( 'vendiajs', 'rest_object',
        array(
            'api_nonce' => wp_create_nonce( 'wp_rest' ),
            'api_url'   => site_url('/wp-json/rest/v1/'),
        )
    );

}


add_action( 'rest_api_init', 'rest_vendia_checkin' );
function rest_vendia_checkin() {
    // Declare our namespace
    $namespace = 'vendia/v1';

    // Register the route
    register_rest_route( $namespace, '/checkin/', array(
        'methods'   => 'POST',
        'callback'  => 'rest_vendia_checkin_handler',
        'args'      => array(
            'location_id'  => array( 'required' => true ),
            'user_nfc_short_id'  => array( 'required' => true ),
        )
    ) );
}

// The callback handler for the endpoint
function rest_vendia_checkin_handler( $request ) {
    // We don't need to specifically check the nonce like with admin-ajax. It is handled by the API.
    $params = $request->get_params();
    $location_id = $params['location_id'];
    $user_nfc_short_id = $params['user_nfc_short_id'];

    $args = array(
      'fields' => 'ID',
    	'meta_query' => array(
  			array(
  				'key'     => 'nfc_short_id',
  				'value'   => $user_nfc_short_id
  			)
    	)
     );
    $users = get_users( $args );
    $user_id = $users[0];

    $location = get_posts( array(
      'post_type' => 'vnd_location',
      'p' => $location_id,
      'fields' => 'ids',
    ) );
    if(!empty($location) && !empty($users)){
      $my_post = array(
        'post_title' => 'TODO Lorenzo', //TODO
        'post_status' => 'publish',
        'post_type' => 'vnd_checkin' );

      $checkin_id = wp_insert_post($my_post);
      //restituisci id_servizio, id_sportello, numero_servito

      add_post_meta($checkin_id, 'location_id', $location_id);
      add_post_meta($checkin_id, 'user_id', $user_id);


      return new WP_REST_Response( array('message' => 'Valid email.'), 200 );
    }

    if ( is_email( $params['email']) ) {

    }

    // Previous check didn't pass, email is invalid.
    return new WP_REST_Response( array('message' => 'Not a valid email.'), 200 );
}
