<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://www.emberware.it
 * @since             1.0.0
 * @package           Vendia_Modalita_vendita
 *
 * @wordpress-plugin
 * Plugin Name:       Api Vendia modalita di vendita 
 * Plugin URI:        https://www.emberware.it
 * Description:       This is a short description of what the plugin does. It's displayed in the WordPress admin area.
 * Version:           1.0.0
 * Author:            Emberware
 * Author URI:        https://www.emberware.it
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       thor
 * Domain Path:       /languages
 */

add_action( 'init', 'aziende' );
function aziende() {
    $args = array(
      'public'       => true,
      'show_in_rest' => true,
      'label'        => 'Aziende',
      "supports" => array( "title", "editor", "thumbnail", "custom-fields" ),
    );
    register_post_type( 'aziende', $args );

    register_meta('post', 'codice_danea', array(
        "object_subtype" => "aziende",
        "type" => "string",
        "show_in_rest" => true // this is the key part
    ));

    register_meta('user', 'Phone_number', array(
        "type" => "string",
        "show_in_rest" => true // this is the key part
    ));
}
add_action( 'init', 'aziende' );

function add_rest_route_for_aziende( $route, $post ) {
    if ( $post->post_type === 'aziende' ) {
        $route = '/wp/v2/aziende/' . $post->ID;
    }
    return $route;
}
add_filter( 'rest_route_for_post', 'add_rest_route_for_aziende', 10, 2 );


add_action( 'woocommerce_product_query', 'hide_unvailable_products' );
function hide_unvailable_products( $q ){
    if(!is_rest_api_request()){
        $venditori_abilitati = ew_producer_list();
        if (!empty($venditori_abilitati)){
            $meta_query = $q->get( 'meta_query' );
            $meta_query[] =  array(
                                'key' => 'produttore',
                                'value' => $venditori_abilitati,
                                'compare' => 'IN',
                            );
            $q->set( 'meta_query', $meta_query );
        }
        else{
            $q->set( 'p', '1' );
        }
    }
}


add_filter('woocommerce_is_purchasable', 'unvailable_product_unpurchasable', 10, 2);
function unvailable_product_unpurchasable($purchasable, $product) {
    if ($purchasable){
        if(!is_rest_api_request()){
            $venditori_abilitati = ew_producer_list();    
            $danea_code = get_post_meta( $product->get_id(), 'produttore', true);
            return in_array($danea_code, $venditori_abilitati);
        }
    }
    return $purchasable;    
// }

function ew_producer_list(){
    return json_decode(get_option('producer_list'));
}


function is_rest_api_request() {
    if ( empty( $_SERVER['REQUEST_URI'] ) ) {
        // Probably a CLI request
        return false;
    }

    $rest_prefix         = trailingslashit( rest_get_url_prefix() );
    $is_rest_api_request = ( false !== strpos( $_SERVER['REQUEST_URI'], $rest_prefix ) );

    return apply_filters( 'is_rest_api_request', $is_rest_api_request );
}
