<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://www.emberware.it
 * @since             1.0.0
 * @package           Vendia_Modalita_Vendita
 *
 * @wordpress-plugin
 * Plugin Name:       Vendia Modalita Vendita 
 * Plugin URI:        https://www.emberware.it
 * Description:       This is a short description of what the plugin does. It's displayed in the WordPress admin area.
 * Version:           1.0.0
 * Author:            Emberware
 * Author URI:        https://www.emberware.it
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       thor
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'EW_VENDIA_MODALITA_VENDITA', '1.0.0' );

if (!defined('ABSPATH')) {
	die();
}

if (!class_exists('Vendia_Modalita_Vendita')) {

	class Vendia_Modalita_Vendita
	{

			public function __construct()
			{
				$this->constants();
				$this->includes();
			}

			public function constants()
			{
					if (!defined('MODALITA_VENDITA_DIR')) {
							define('MODALITA_VENDITA_DIR', plugin_dir_path(__FILE__));
					}

					if (!defined('MODALITA_VENDITA_DIR_URL')) {
							define('MODALITA_VENDITA_DIR_URL', plugin_dir_url(__FILE__));
					}
			}

			public function includes()
			{
					require_once MODALITA_VENDITA_DIR . 'includes/ew-aziende-vendia-modalita-vendita.php';
					require_once MODALITA_VENDITA_DIR . 'includes/ew-api-vendia-modalita-vendita.php';
			}

	}
	$modalita_vendita = new Vendia_Modalita_Vendita();
	
}
