<?php
/*
Plugin Name: OPTION API plugin
Plugin URI: http://emberware.it/
Description: OPTION API plugin
Author: Emberware
Version: 1.0
Author URI: http://emberware.it/
*/
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if (! class_exists ('EW_OPTION_API')){
    class EW_OPTION_API {
        public static function register_routes() {
            $version = '2';
            $namespace = 'vnd/v' . $version;
            register_rest_route($namespace, 'producer-list', array(
                'methods' => WP_REST_Server::EDITABLE,
                'callback' => 'rest_update_producer_list',
                )
            );
        }
        public static function init(){
            add_action( 'rest_api_init', array( __CLASS__, 'register_routes' ), 12 );
        }
    }
}
add_action ('plugins_loaded', array('EW_OPTION_API', 'init'));

 /**
 * Function for update single option
 */
function rest_update_producer_list($request){
        
        $option_producer = get_option( 'producer_list' );
        $newvalue = $request->get_body();

        if(!$option_producer || $option_producer == ""){
            add_option('producer_list', $newvalue);             
        }else{
            update_option( 'producer_list', $newvalue );
        }
}

