<?php
/*
Plugin Name: Vendia WooSync
Description: Plugin to manage buying groups
Author: Emberware
Text Domain: vendia_woosync
Domain Path: /languages
 */

if (!defined('ABSPATH')) {
    die();
}

if (!class_exists('Vendia_Woosync')) {

    class Vendia_Woosync
    {

        public function __construct()
        {
            $this->constants();
            $this->includes();
            $danea = new Danea();

            add_filter('acf/settings/load_json', array($this, 'my_acf_json_load_point'));
        }

        public function constants()
        {
            if (!defined('VENDIAWOOSYNC_DIR')) {
                define('VENDIAWOOSYNC_DIR', plugin_dir_path(__FILE__));
            }

            if (!defined('VENDIAWOOSYNC_DIR_URL')) {
                define('VENDIAWOOSYNC_DIR_URL', plugin_dir_url(__FILE__));
            }
        }

        public function includes()
        {
            require_once VENDIAWOOSYNC_DIR . 'inc/class-danea.php';
        }

        public static function vendia_woosync_activation()
        {
            global $wpdb;
            global $jal_db_version;
        }

        public function my_acf_json_load_point($paths)
        {
            // append path
            $paths[] = VENDIAWOOSYNC_DIR . 'acf-json';

            // return
            return $paths;

        }

    }
    $vendia_woosync = new Vendia_Woosync();

    register_activation_hook(__FILE__, array('Vendia_Gruppi', 'vendia_woosync_activation'));
}