<?php
class Danea
{
    public function __construct()
    {
        add_action('init', array($this, 'vendia_woosync_auto_login'));
        add_action('admin_menu', array($this, 'vendia_woosync_register_danea_menu_actions'), -10);
    }

    /**
     * Adds a submenu page under a custom post type parent.
     */
    public function vendia_woosync_register_danea_menu_actions()
    {
        add_menu_page('Vendia WooSync', 'WooSync', 'edit_pages', 'daneawoo-impostazioni', null, VENDIAWOOSYNC_DIR_URL .'inc/icone/icona_plugin_danea_woocommerce.png');
        add_submenu_page( 'daneawoo-impostazioni', 'Impostazioni', 'Impostazioni', 'edit_pages', 'daneawoo-impostazioni', array($this, 'vendia_woosync_impostazioni') );
        add_submenu_page( 'daneawoo-impostazioni', 'Upload prodotti', 'Upload prodotti', 'edit_pages', 'daneawoo-prodotti-import', array($this, 'vendia_woosync_prodotti_import') );
        add_submenu_page( 'daneawoo-impostazioni', 'Elimina tutti i prodotti', 'Elimina tutti i prodotti', 'edit_pages', 'daneawoo-prodotti-svuota', array($this, 'daneawoo_prodotti_svuota') );
        add_submenu_page( 'daneawoo-impostazioni', 'Upload immagini', 'Upload immagini', 'edit_pages', 'daneawoo-prodotti-immagini', array($this, 'vendia_woosync_prodotti_immagini_import') );
        add_submenu_page( 'daneawoo-impostazioni', 'Invia ordini a Danea', 'Donwload ordini', 'edit_pages', 'daneawoo-ordini', array($this, 'daneawoo_ordini_donwload') );
        add_submenu_page( 'daneawoo-impostazioni', 'Info', 'Info', 'edit_pages', 'daneawoo-info', array($this, 'info') );
    }
    public function info()
    {
        echo phpinfo();
    }
    public function vendia_woosync_impostazioni()
    {
        if(isset($_POST['impostazioni_set']))
        {
            /* Parametri azienda per download ordini */
            update_option('daneawoo_company_name', $_POST['company_name']);
            update_option('daneawoo_company_address', $_POST['company_address']);
            update_option('daneawoo_company_cap', $_POST['company_cap']);
            update_option('daneawoo_company_city', $_POST['company_city']);
            update_option('daneawoo_company_province', $_POST['company_province']);
            update_option('daneawoo_company_country', $_POST['company_country']);
            update_option('daneawoo_company_fiscalcode', $_POST['company_fiscalcode']);
            update_option('daneawoo_company_vatcode', $_POST['company_vatcode']);
            update_option('daneawoo_company_tel', $_POST['company_tel']);
            update_option('daneawoo_company_fax', $_POST['company_fax']);
            update_option('daneawoo_company_email', $_POST['company_email']);
            update_option('daneawoo_company_homepage', $_POST['company_homepage']);

            /* Parametri per gestione magazzino */
            if(isset($_POST['stock']) && $_POST['stock']=="si")
                update_option('daneawoo_stock', true);
            else
                update_option('daneawoo_stock', false);

            /* Parametri per prodotti */
            update_option('daneawoo_product_custom_field_1', $_POST['custom_field_1']);
            update_option('daneawoo_product_custom_field_2', $_POST['custom_field_2']);
            update_option('daneawoo_product_custom_field_3', $_POST['custom_field_3']);
            update_option('daneawoo_product_custom_field_4', $_POST['custom_field_4']);
            update_option('daneawoo_product_tags', $_POST['tags']);
            update_option('daneawoo_grossprice',  $_POST['GrossPrice']);

            update_option('daneawoo_filter_roles', json_encode($_POST['roles']));

            global $wpdb, $woocommerce;

            if(!empty($_POST['custom_field_1']))
            {
				$id = wc_attribute_taxonomy_id_by_name('pa_' . strtolower($_POST['custom_field_1']));
				$id = ($id != 0 ? $id : wc_attribute_taxonomy_id_by_name(strtolower($_POST['custom_field_1'])));
				wc_create_attribute([
					'id' => $id,
					'name' => $_POST['custom_field_1'],
					'slug' => strtolower($_POST['custom_field_1']),
					'type' => 'text',
					'order_by' => 'menu_order'
                ]);
            }

            if(!empty($_POST['custom_field_2']))
            {
				$id = wc_attribute_taxonomy_id_by_name('pa_' . strtolower($_POST['custom_field_2']));
				$id = ($id != 0 ? $id : wc_attribute_taxonomy_id_by_name(strtolower($_POST['custom_field_2'])));
				wc_create_attribute([
					'id' => $id,
					'name' => $_POST['custom_field_2'],
					'slug' => strtolower($_POST['custom_field_2']),
					'type' => 'text',
					'order_by' => 'menu_order'
                ]);
            }

            if(!empty($_POST['custom_field_3']))
            {
				$id = wc_attribute_taxonomy_id_by_name('pa_' . strtolower($_POST['custom_field_3']));
				$id = ($id != 0 ? $id : wc_attribute_taxonomy_id_by_name(strtolower($_POST['custom_field_3'])));
				wc_create_attribute([
					'id' => $id,
					'name' => $_POST['custom_field_3'],
					'slug' => strtolower($_POST['custom_field_3']),
					'type' => 'text',
					'order_by' => 'menu_order'
                ]);
            }

            if(!empty($_POST['custom_field_4']))
            {
				$id = wc_attribute_taxonomy_id_by_name('pa_' . strtolower($_POST['custom_field_4']));
				$id = ($id != 0 ? $id : wc_attribute_taxonomy_id_by_name(strtolower($_POST['custom_field_4'])));
				wc_create_attribute([
					'id' => $id,
					'name' => $_POST['custom_field_4'],
					'slug' => strtolower($_POST['custom_field_4']),
					'type' => 'text',
					'order_by' => 'menu_order'
                ]);
            }


        }

        ?>
        <div class="wrap">
            <div class="icon32"><img src="<?php echo VENDIAWOOSYNC_DIR_URL .'inc/icone/icona_plugin_danea_woocommerce_32x32.png' ?>" /><br></div>
            <h2>Impostazioni generali di Vendia WooSync</h2>
            <form  action="admin.php?page=daneawoo-impostazioni" method="post" name="download_impostazioni_form" id="download_impostazioni_form">
                <input type="hidden" id="impostazioni_set" name="impostazioni_set" value="si" />
                <table class="form-table">
                    <tbody>
                        <tr>
                            <th scope="row" colspan="2">
                                <h3>Filtri</h3>
                            </th>
                        </tr>
                        <tr class="form-field">
                            <th scope="row"><label for="lastnum">Cliente con i seguenti ruoli</label></th>
                            <td>
                                <?php
                                    global $wp_roles;
                                    $selected_roles = json_decode(get_option('daneawoo_filter_roles', '')) ?: [];
                                    foreach($wp_roles->roles as $key => $role){
                                        ?>
                                        <input type="checkbox" name="roles[]" value="<?= $key ?>"  <?php if(in_array($key, $selected_roles)) echo "checked";?>> <?= $role['name'] ?><br>
                                        <?php
                                    }
                                ?>
                            </td>
                        </tr>
                        <tr class="form-field">
                            <th scope="row" colspan="2">
                                <h3>Dati azienda</h3>
                              </th>
                        </tr>
                        <tr class="form-field">
                            <th scope="row"><label for="firstdate">Denominazione</label></th>
                            <td><input name="company_name" type="text" id="company_name" value="<?php echo get_option('daneawoo_company_name', '') ?>" style="width: 25em"></td>
                        </tr>
                        <tr class="form-field">
                            <th scope="row"><label for="lastdate">Indirizzo</label></th>
                            <td><input name="company_address" type="text" id="company_address" value="<?php echo get_option('daneawoo_company_address', '') ?>" style="width: 25em"></td>
                        </tr>
                        <tr class="form-field">
                            <th scope="row"><label for="firstnum">Cap</label></th>
                            <td><input name="company_cap" type="text" id="company_cap" value="<?php echo get_option('daneawoo_company_cap', '') ?>" style="width: 25em"> </td>
                        </tr>
                        <tr class="form-field">
                            <th scope="row"><label for="lastnum">Città</label></th>
                            <td><input name="company_city" type="text" id="company_city" value="<?php echo get_option('daneawoo_company_city', '') ?>" style="width: 25em"> </td>
                        </tr>
                        <tr class="form-field">
                            <th scope="row"><label for="lastnum">Provincia</label></th>
                            <td><input name="company_province" type="text" id="company_province" value="<?php echo get_option('daneawoo_company_province', '') ?>" style="width: 25em"> </td>
                        </tr>
                        <tr class="form-field">
                            <th scope="row"><label for="lastnum">Nazione</label></th>
                            <td><input name="company_country" type="text" id="company_country" value="<?php echo get_option('daneawoo_company_country', '') ?>" style="width: 25em"> </td>
                        </tr>
                        <tr class="form-field">
                            <th scope="row"><label for="lastnum">Codice Fiscale</label></th>
                            <td><input name="company_fiscalcode" type="text" id="company_fiscalcode" value="<?php echo get_option('daneawoo_company_fiscalcode', '') ?>" style="width: 25em"> </td>
                        </tr>
                        <tr class="form-field">
                            <th scope="row"><label for="lastnum">Partita IVA</label></th>
                            <td><input name="company_vatcode" type="text" id="company_vatcode" value="<?php echo get_option('daneawoo_company_vatcode', '') ?>" style="width: 25em"> </td>
                        </tr>
                        <tr class="form-field">
                            <th scope="row"><label for="lastnum">Telefono</label></th>
                            <td><input name="company_tel" type="text" id="company_tel" value="<?php echo get_option('daneawoo_company_tel', '') ?>" style="width: 25em"> </td>
                        </tr>
                        <tr class="form-field">
                            <th scope="row"><label for="lastnum">Fax</label></th>
                            <td><input name="company_fax" type="text" id="company_fax" value="<?php echo get_option('daneawoo_company_fax', '') ?>" style="width: 25em"> </td>
                        </tr>
                        <tr class="form-field">
                            <th scope="row"><label for="lastnum">Email</label></th>
                            <td><input name="company_email" type="text" id="company_email" value="<?php echo get_option('daneawoo_company_email', '') ?>" style="width: 25em"> </td>
                        </tr>
                        <tr class="form-field">
                            <th scope="row"><label for="lastnum">Sito web</label></th>
                            <td><input name="company_homepage" type="text" id="company_homepage" value="<?php echo get_option('daneawoo_company_homepage', '') ?>" style="width: 25em"> </td>
                        </tr>
                        <tr class="form-field">
                            <th scope="row" colspan="2">
                                <h3>Gestione magazzino</h3>
                              </th>
                        </tr>
                         <tr class="form-field">
                            <th scope="row"><label for="lastnum">Movimentazione del magazzino</label></th>
                            <td>
                            <?php
                                $stock_checked = false;
                                $stock_val = get_option('daneawoo_stock', '');
                                if($stock_val == "1")
                                    $stock_checked = "checked";

                            ?>
                            <input name="stock" type="checkbox" id="stock" value="si" style="width: 5em" <?php echo $stock_checked ?>> Abilita movimentazione magazzino</td>
                        </tr>
                        <tr class="form-field">
                            <th scope="row" colspan="2">
                                <h3>Gestione prodotti</h3>
                              </th>
                        </tr>
                        <tr class="form-field">
                            <th scope="row"><label for="lastnum">Campo con il prezzo</label></th>
                            <td><select id="GrossPrice" name="GrossPrice" style="width: 25em">
                                <option id="custom_field_1" value="GrossPrice1" <?php if(get_option('daneawoo_grossprice', '') == "GrossPrice1") { echo "selected"; } ?>>Listino 1</option>
                                <option id="custom_field_2" value="GrossPrice2" <?php if(get_option('daneawoo_grossprice', '') == "GrossPrice2") { echo "selected"; } ?>>Listino 2</option>
                                <option id="custom_field_3" value="GrossPrice3" <?php if(get_option('daneawoo_grossprice', '') == "GrossPrice3") { echo "selected"; } ?>>Listino 3</option>
                                <option id="custom_field_4" value="GrossPrice4" <?php if(get_option('daneawoo_grossprice', '') == "GrossPrice4") { echo "selected"; } ?>>Listino 4</option>
                            </select></td>
                        </tr>
                        <tr class="form-field">
                            <th scope="row"><label for="lastnum">Campo libero contenente i tags</label></th>
                            <td>
                            <select id="tags" name="tags" style="width: 25em">
                                <option id="custom_field_1" value="1" <?php if(get_option('daneawoo_product_tags', '') == "1") { echo "selected"; } ?>>Campo libero 1</option>
                                <option id="custom_field_2" value="2" <?php if(get_option('daneawoo_product_tags', '') == "2") { echo "selected"; } ?>>Campo libero 2</option>
                                <option id="custom_field_3" value="3" <?php if(get_option('daneawoo_product_tags', '') == "3") { echo "selected"; } ?>>Campo libero 3</option>
                                <option id="custom_field_4" value="4" <?php if(get_option('daneawoo_product_tags', '') == "4") { echo "selected"; } ?>>Campo libero 4</option>
                            </select>
                            </td>
                        </tr>
                        <tr class="form-field">
                            <th scope="row"><label for="lastnum">Etichetta campo libero 1</label></th>
                            <td><input name="custom_field_1" type="text" id="custom_field_1" value="<?php echo get_option('daneawoo_product_custom_field_1', '') ?>" style="width: 25em"> </td>
                        </tr>
                        <tr class="form-field">
                            <th scope="row"><label for="lastnum">Etichetta campo libero 2</label></th>
                            <td><input name="custom_field_2" type="text" id="custom_field_2" value="<?php echo get_option('daneawoo_product_custom_field_2', '') ?>" style="width: 25em"> </td>
                        </tr>
                        <tr class="form-field">
                            <th scope="row"><label for="lastnum">Etichetta campo libero 3</label></th>
                            <td><input name="custom_field_3" type="text" id="custom_field_3" value="<?php echo get_option('daneawoo_product_custom_field_3', '') ?>" style="width: 25em"> </td>
                        </tr>
                        <tr class="form-field">
                            <th scope="row"><label for="lastnum">Etichetta campo libero 4</label></th>
                            <td><input name="custom_field_4" type="text" id="custom_field_4" value="<?php echo get_option('daneawoo_product_custom_field_4', '') ?>" style="width: 25em"> </td>
                        </tr>

                    </tbody>
                </table>
                <p class="submit"><input type="submit" name="impostazioni_button" id="impostazioni_button" class="button button-primary" value="Salva impostazioni"></p>
            </form>
        </div>
        <?php

    }

    public function vendia_woosync_prodotti_upload_file()
    {
        ?>
            <h4>Carica un file .xml o .txt con i prodotti da inserire/aggiornare</h4>
            <form method="post" enctype="multipart/form-data" class="wp-upload-form" action="admin.php?page=daneawoo-prodotti-import" name="prodotti_carica_xml" id="prodotti_carica_xml">
                <table class="form-table">
                    <tbody>
                        <tr class="form-field">
                            <th scope="row"><label for="xml_prodotti">File .xml dei prodotti</label></th>
                            <td><input type="file" id="xml_prodotti" name="xml_prodotti" style="width: 45em"></td>
                        </tr>
                        <tr class="form-field">
                            <th scope="row"><label for="hierarchical_categories">Importare categorie gerarchiche</label></th>
                            <td>
                                <input type="radio" name="hierarchical_categories" value="1"> Si<br>
                                <input type="radio" name="hierarchical_categories" value="0" checked> No<br>
                            </td>
                        </tr>
                        <tr class="form-field">
                            <th scope="row"><label for="delete_categories">Cancellare categorie associate ai vecchi prodotti</label></th>
                            <td>
                                <input type="radio" name="delete_categories" value="1"> Si<br>
                                <input type="radio" name="delete_categories" value="0" checked> No<br>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <p class="submit"><input type="submit" name="xml-prodotti-submit" id="xml-prodotti-submit" class="button  button-primary" value="Upload xml"></p>
            </form>
        <?php
    }

    public function vendia_woosync_prodotti_import()
    {
        // se è stato caricato un file .xml usando direttamente la pagina
        if (isset($_FILES['xml_prodotti']))
        {
            ?>
                <div class="wrap">
                    <div class="icon32"><img src="<?php echo VENDIAWOOSYNC_DIR_URL .'inc/icone/icona_plugin_danea_woocommerce_32x32.png' ?>" /><br></div>
                    <h2>Importa prodotti</h2>
                    <br />
            <?php
            // verifichiamo che l'utente abbia selezionato un file
            if(trim($_FILES["xml_prodotti"]["name"]) == '')
            {
                echo '<div id="message" class="error below-h2"><p>Non hai selezionato nessun file!</p></div>';
                $this->vendia_woosync_prodotti_upload_file();
                die();
            }
            // verifichiamo che il file � stato caricato
            else if(!is_uploaded_file($_FILES["xml_prodotti"]["tmp_name"]) || $_FILES["xml_prodotti"]["error"]>0)
            {
                error_log("Il file ".$_FILES["xml_prodotti"]["tmp_name"]." non è stato caricato correttamente, codice errore = ".$_FILES["xml_prodotti"]["error"]);
                echo '<div id="message" class="error below-h2"><p>Si sono verificati problemi nella procedura di upload!</p></div>';
                $this->vendia_woosync_prodotti_upload_file() ;
                die();
            }

            $wp_filetype = wp_check_filetype(basename($_FILES["xml_prodotti"]["name"]), null );

            $count = $this->importProdotti($_FILES["xml_prodotti"]);

            echo "<br ><div id='message' class='updated below-h2'><p>" . $count . " prodotti importati e/o aggiornati</p></div>";
            ?>
                </div>
            <?php
        }
        // E' stato inviato un file direttamente da Danea $_FILES["file"]["tmp_name"]: percorso e il nome del file temporaneo sul server
        else if(isset($_FILES['file']))
        {
            $count = $this->importProdotti($_FILES["file"]);
            // $count = 1026;
            if($count>0)
            {
                // Nel caso in cui il sito di e-commerce, al termine della ricezione dell'elenco prodotti, desideri ricevere anche le relative immagini, gli sar� necessario aggiungere,
                // successivamente all'OK di risposta, i seguenti parametri: ImageSendURL=URL e ImageSendFinishURL=URL (opzionale)
                // E' importante che le diverse righe contenenti OK, ImageSendURL e ImageSendFinishURL siano separate da un carattere di INVIO ("new line").
                // L'invio delle immagini in modalit� HTTP avverr� con un post per ciascun file trasmesso in modalit� Content-type "multipart/form-data" contenente due parametri:
                // "file" (il file trasmesso) e "fileName" (il nome del file).
                ob_clean();
                die("OK\r\nImageSendURL=http://" . $_SERVER['SERVER_NAME'] . "/wp-admin/admin.php?page=daneawoo-prodotti-immagini");
            }
            else
            {
                echo 'NESSUN prodotto da aggiornare ';
            }
            die();
        }
        // nessun file da caricare, visualizzo la pagina per caricarlo
        else
        {
            ?>
            <div class="wrap">
                <div class="icon32"><img src="<?php echo VENDIAWOOSYNC_DIR_URL .'inc/icone/icona_plugin_danea_woocommerce_32x32.png' ?>" /><br></div>
                <h2>Importa prodotti</h2>
                <br />
            <?php
            $this->vendia_woosync_prodotti_upload_file();
            ?>
                </div>
            <?php
            die();
        }
    }

    public function vendia_woosync_immagini_upload_form()
    {
        ?>
        <h4>Carica il file dell'immagine</h4>
        <form class="wp-upload-form" action="admin.php?page=daneawoo-prodotti-immagini" method="post" enctype="multipart/form-data"  name="foto_carica_form" id="foto_carica_form">
        <table class="form-table">
            <tbody>
                <tr class="form-field">
                    <th scope="row"><label for="fileName">Nome file</label></th>
                    <td><input type="text" name="fileName" id="fileName"  style="width: 25em" /></td>
                </tr>
                <tr class="form-field">
                    <th scope="row"><label for="file">Immagine</label></th>
                    <td><input type="file" name="file" if="file"  style="width: 45em" /></td>
                </tr>
            </tbody>
        </table>
        <input type="hidden" id="da_pagina" name="da_pagina" value="si" />
        <p class="submit"><input type="submit" name="upload_buttone" id="upload_buttone" value="Upload" class="button  button-primary" /></p>

        </form>
        <?php
    }

    public function vendia_woosync_prodotti_immagini_import()
    {
        // L'invio delle immagini in modalita' HTTP avverra'' con un post per ciascun file trasmesso in modalita'' Content-type "multipart/form-data" contenente due parametri:
        // "file" (il file trasmesso) e "fileName" (il nome del file).
        if(isset($_FILES['file']) && isset($_POST['fileName']))
        {
            // arrivo direttamente da Danea quindi effettuo il login
            if(!isset($_POST['da_pagina']))
            {
                //	Commentato perchè danea non rimanda le credenziali inviando le immagini
                //	$this->verificaCredenzialiDanea();
                $is_logged =  true;
            }
            else
            {
                $is_logged = true;

                ?>
                    <div class="wrap">
                        <div class="icon32"><img src="<?php echo VENDIAWOOSYNC_DIR_URL .'inc/icone/icona_plugin_danea_woocommerce_32x32.png' ?>" /><br></div>
                        <h2>Upload immagini prodotti</h2>
                        <br />
                <?php

            }


            if(	$is_logged )
            {
                $code_e_altro = explode(" -- ", $_POST['fileName']);

                $args_prodotto = array(
                    'post_type' => 'product',
                    'meta_query' => array(
                        array(
                            'key' => '_sku',
                            'value' => $code_e_altro[0],
                        )
                    )
                );
                $prodotto = get_posts( $args_prodotto );
                foreach($prodotto as $p)
                {
                    $prod = get_post($p->ID);
                }

                $nome_immagine = $code_e_altro[0];
                $nome_prodotto = $prod->post_name;
                $wp_filetype = wp_check_filetype(basename( $_FILES["file"]["name"]), null );
                $nome_immagine = basename($nome_prodotto) . "." . $wp_filetype['ext'];

                $percorso_file = ABSPATH . 'wp-content/uploads/images/products/' . $nome_immagine;

                // il move_uploaded_file dovrebbe sovrascrivere un file se ha lo stesso nome
                if(file_exists($percorso_file))
                {
                    rename($percorso_file, $percorso_file.".old");
                    // unlink($percorso_file);
                }
                    move_uploaded_file( $_FILES["file"]["tmp_name"], $percorso_file);

                    if(!isset($_POST['da_pagina']))
                        die("OK");
                    else
                        echo "<br ><div id='message' class='updated below-h2'><p>Immagine " . $nome_immagine . " uploadata</p></div>";
                /*}
                else
                    if(!isset($_POST['da_pagina']))
                        die("OK");
                    else
                        echo "Immagine gia' presente";*/
            }
            else
            {
                if(!isset($_POST['da_pagina']))
                    die("Non hai il permesso di portare a termine l'operazione richiesta");
                else
                    echo "Non hai il permesso di portare a termine l'operazione richiesta";
            }
        }
        // non sto inviando le immagini da Danea, quindi mostro la pagina per il caricamento manuale
        else
        {
            ?>
                <div class="wrap">
                    <div class="icon32"><img src="<?php echo VENDIAWOOSYNC_DIR_URL .'inc/icone/icona_plugin_danea_woocommerce_32x32.png' ?>" /><br></div>
                    <h2>Upload immagini prodotti</h2>
                    <br />
            <?php
            $this->vendia_woosync_immagini_upload_form();
        }
    ?>
        </div>
    <?php
    }

    // viene chiamata all'esecuzione del login, se arrivo da danea effettua il login con le credenziali di Danea e mi logga in wordpress
    public function vendia_woosync_auto_login()
    {
        if (!is_user_logged_in())
        {
            if(isset($_REQUEST["page"]))
            {
                if($_REQUEST["page"] == "daneawoo" || $_REQUEST["page"] == "daneawoo-impostazioni" || $_REQUEST["page"] == "daneawoo-prodotti-svuota" || $_REQUEST["page"] == "daneawoo-prodotti-immagini" || $_REQUEST["page"] == "daneawoo-ordini")
                {
                if(!$this->verificaCredenzialiDanea())
                        die("ERRORE di autenticazione");
                else
                {
                        if($_REQUEST["page"] == "daneawoo")
                            $this->vendia_woosync_prodotti_import();
                        else if($_REQUEST["page"] == "daneawoo-prodotti-immagini")
                            $this->vendia_woosync_prodotti_immagini_import();
                        else if($_REQUEST["page"] == "daneawoo-prodotti-svuota")
                            $this->daneawoo_prodotti_svuota();
                        else if ($_REQUEST["page"] == "daneawoo-ordini")
                            $this->daneawoo_ordini_donwload();
                        else
                            $this->vendia_woosync_impostazioni();
                    }
                }
            }
        }
    }

    /**
     * @return string[] dati del negozio
     */
    public function get_company_options()
    {
        $company_options = [];

        //  get_option( $option, $default ); -> se l'option esiste la restituisce, altrimenti restituisce il valore in $default
        $company_options['daneawoo_company_name'] = get_option('daneawoo_company_name', '');
        $company_options['daneawoo_company_address'] = get_option('daneawoo_company_address', '');
        $company_options['daneawoo_company_cap'] = get_option('daneawoo_company_cap', '');
        $company_options['daneawoo_company_city'] = get_option('daneawoo_company_city', '');
        $company_options['daneawoo_company_province'] = get_option('daneawoo_company_province', '');
        $company_options['daneawoo_company_country'] = get_option('daneawoo_company_country', '');
        $company_options['daneawoo_company_fiscalcode'] = get_option('daneawoo_company_fiscalcode', '');
        $company_options['daneawoo_company_vatcode'] = get_option('daneawoo_company_vatcode', '');
        $company_options['daneawoo_company_tel'] = get_option('daneawoo_company_tel', '');
        $company_options['daneawoo_company_fax'] = get_option('daneawoo_company_fax', '');
        $company_options['daneawoo_company_email'] = get_option('daneawoo_company_email', '');
        $company_options['daneawoo_company_homepage'] = get_option('daneawoo_company_homepage', '');

        return $company_options;
    }

    /**
     * @return DOMElement dati del negozio
     */
    public function get_ele_company_xml($xml)
    {
        $company_options = $this->get_company_options();
        $ele_company = $xml->createElement('Company');

        $ele_company_name = $xml->createElement('Name', $company_options['daneawoo_company_name']);
        $ele_company->appendChild($ele_company_name);
        $ele_company_adress = $xml->createElement('Address', $company_options['daneawoo_company_address']);
        $ele_company->appendChild($ele_company_adress);
        $ele_company_postcode = $xml->createElement('Postcode', $company_options['daneawoo_company_cap']);
        $ele_company->appendChild($ele_company_postcode);
        $ele_company_city = $xml->createElement('City', $company_options['daneawoo_company_city']);
        $ele_company->appendChild($ele_company_city);
        $ele_company_province = $xml->createElement('Province', $company_options['daneawoo_company_province']);
        $ele_company->appendChild($ele_company_province);
        $ele_company_country = $xml->createElement('Country', $company_options['daneawoo_company_country']);
        $ele_company->appendChild($ele_company_country);
        $ele_company_fiscalcode = $xml->createElement('FiscalCode', $company_options['daneawoo_company_fiscalcode']);
        $ele_company->appendChild($ele_company_fiscalcode);
        $ele_company_piva = $xml->createElement('VatCode', $company_options['daneawoo_company_vatcode']);
        $ele_company->appendChild($ele_company_piva);
        $ele_company_tel = $xml->createElement('Tel', $company_options['daneawoo_company_tel']);
        $ele_company->appendChild($ele_company_tel);
        $ele_company_fax = $xml->createElement('Fax', $company_options['daneawoo_company_fax']);
        $ele_company->appendChild($ele_company_fax);
        $ele_company_email = $xml->createElement('Email', $company_options['daneawoo_company_email']);
        $ele_company->appendChild($ele_company_email);
        $ele_company_web = $xml->createElement('HomePage', $company_options['daneawoo_company_homepage']);
        $ele_company->appendChild($ele_company_web);

        return $ele_company;
    }

    /**
     * @return DOMElement dati iniziali
     */
    public function get_ele_easyfattDoc_xml($xml)
    {
        $ele_easyfattDoc = $xml->createElement('EasyfattDocuments');

        $attr_app_version = $xml->createAttribute('AppVersion');
        $attr_app_version->value = '2';
        $ele_easyfattDoc->appendChild($attr_app_version);

        $attr_app_creator = $xml->createAttribute('Creator');
        $attr_app_creator->value = 'Danea Soft';
        $ele_easyfattDoc->appendChild($attr_app_creator);

        $attr_app_url = $xml->createAttribute('CreatorUrl');
        $attr_app_url->value = 'www.danea.it';
        $ele_easyfattDoc->appendChild($attr_app_url);
        return $ele_easyfattDoc;
    }


    public function daneawoo_ordini_donwload()
    {
        // se è definito o arrivo da Danea che me lo invia oppure dalla pagina
        if(isset($_POST['appver']) || isset($_GET['appver']))
        {

            if(!isset($_POST['da_pagina']))
            {
                $is_logged =  $this->verificaCredenzialiDanea();
            }
            else
            {
                $is_logged = true;

                ?>
                    <div class="wrap">
                        <div class="icon32"><img src="<?php echo VENDIAWOOSYNC_DIR_URL .'inc/icone/icona_plugin_danea_woocommerce_32x32.png' ?>" /><br></div>
                        <h2>Download ordini</h2>
                        <br />
                <?php

            }

            if(	$is_logged )
            {
                $xml = new DOMDocument('1.0', 'UTF-8');

                $ele_easyfattDoc = $this->get_ele_easyfattDoc_xml($xml);
                $ele_company = $this->get_ele_company_xml($xml);
                $ele_easyfattDoc->appendChild($ele_company);

                /************ BEGIN DOCUMENTS ************/
                $ele_documents = $xml->createElement('Documents');
                $utenti_query = get_users(['role__in' => json_decode(get_option('daneawoo_filter_roles', ''))]);
                $utenti_gruppi = array();
                foreach($utenti_query as $utente){
                    array_push($utenti_gruppi, $utente->ID);
                }
                wp_reset_query();
                $ordini_args = array(
                    'post_type' => 'shop_order',
                    'post_status' => 'wc-pending',
                    'nopaging' => true,
                    'orderby' => 'meta_value_num',
                    'meta_key' => '_customer_user',
                    'order'   => 'ASC',
                    'meta_query' => array(
                        array(
                            'key' => '_customer_user',
                            'value' => $utenti_gruppi,
                            'compare' => 'IN'
                        )
                    )
                );

                $wc_orders = get_posts($ordini_args);
                foreach($wc_orders as $the_order){
                    $the_order = wc_create_order(['order_id' => $the_order->ID]);

                    $ele_document = $xml->createElement('Document');
                    $ele_documents->appendChild($ele_document);

                    $ele_document_type = $xml->createElement('DocumentType', 'C');	// C = ordine cliente
                    $ele_document->appendChild($ele_document_type);
                    $ele_document_date = $xml->createElement('Date', (string)date_format(new DateTime($the_order->order_date), 'Y-m-d'));		// danea la vuole nel formato 2010-03-23
                    $ele_document->appendChild($ele_document_date);
                    $ele_document_number = $xml->createElement('Number',$the_order->ID);
                    $ele_document->appendChild($ele_document_number);
                    $ele_document_total = $xml->createElement('Total',$the_order->order_total);
                    $ele_document->appendChild($ele_document_total);
                    $ele_document_payment_name = $xml->createElement('PaymentName',$the_order->payment_method_title);
                    $ele_document->appendChild($ele_document_payment_name);
                    $ele_document_comment = $xml->createElement('InternalComment',$the_order->customer_note);
                    $ele_document->appendChild($ele_document_comment);
                    $ele_document_tax = $xml->createElement('CostAmount', ($the_order->order_tax+$the_order->order_shipping_tax));
                    $ele_document->appendChild($ele_document_tax);
                    $ele_document_include_vat = $xml->createElement('PricesIncludeVat', 'true');
                    $ele_document->appendChild($ele_document_include_vat);

                    $customer_id = get_post_meta( $the_order->ID, '_customer_user', true );
                    $customer = get_userdata( $customer_id );
                    $groups = get_posts( array(
                        'connected_type' => 'group_user',
                        'connected_items' => $customer,
                      ) );
                    /************ BEGIN DATI CLIENTE ************/
                    $gruppo_customer_code = get_user_meta(get_post_meta($the_order->ID, '_customer_user', true), "id_danea", true);
                    $ele_customer_code = $xml->createElement('CustomerCode', $gruppo_customer_code);
                    $ele_document->appendChild($ele_customer_code);

                    $customerName = $customer->first_name." ".$customer->last_name;
                    $ele_customer_name = $xml->createElement('CustomerName', (string)$customerName);
                    $ele_document->appendChild($ele_customer_name);
                    /************ END DATI CLIENTE ************/


                    /************ BEGIN DATI SPEDIZIONE CLIENTE ************/
                    if( ($the_order->billing_first_name!=$the_order->shipping_first_name) || ($the_order->billing_last_name!=$the_order->shipping_last_nam) || ($the_order->billing_address_1!=$the_order->shipping_address_1) || ($the_order->billing_address_2!=$the_order->shipping_address_2) || ($the_order->billing_city!=$the_order->shipping_city) || ($the_order->billing_postcode!=$the_order->shipping_postcod) || ($the_order->billing_state!=$the_order->shipping_state))
                    {
                        $ele_customer_delivery_name = $xml->createElement('DeliveryName', $the_order->shipping_first_name . " " . $the_order->shipping_last_name);
                        $ele_document->appendChild($ele_customer_delivery_name);
                        $ele_customer_delivery_address = $xml->createElement('DeliveryAddress', trim($the_order->shipping_address_1 . " " . $the_order->shipping_address_2));
                        $ele_document->appendChild($ele_customer_delivery_address);
                        $ele_customer_delivery_postcode = $xml->createElement('DeliveryPostcode', $the_order->shipping_postcode);
                        $ele_document->appendChild($ele_customer_delivery_postcode);
                        $ele_customer_delivery_city = $xml->createElement('DeliveryCity', $the_order->shipping_city);
                        $ele_document->appendChild($ele_customer_delivery_city);
                        $ele_customer_delivery_province = $xml->createElement('DeliveryProvince', $the_order->shipping_state);
                        $ele_document->appendChild($ele_customer_delivery_province);
                        $ele_customer_delivery_country = $xml->createElement('DeliveryCountry', $the_order->shipping_country);
                        $ele_document->appendChild($ele_customer_delivery_country);
                    }
                    /************ END DATI SPEDIZIONE CLIENTE ************/



                    /************ BEGIN PAGAMENTI ************/
                    $ele_payments = $xml->createElement('Payments');

                    $ele_payment = $xml->createElement('Payment');
                    $ele_payments->appendChild($ele_payment);

                    $ele_payment_advance = $xml->createElement('Advance','false');	//Se "true", segnala che il pagamento è riferito ad un acconto
                    $ele_payment->appendChild($ele_payment_advance);
                    $ele_payment_date = $xml->createElement('Date',null);
                    $ele_payment->appendChild($ele_payment_date);
                    $ele_payment_amount = $xml->createElement('Amount',$the_order->order_total);
                    $ele_payment->appendChild($ele_payment_amount);

                    if($the_order->status == 'completed')
                    {
                        $ele_payment_paid = $xml->createElement('Paid','true');
                    }
                    else
                    {
                        $ele_payment_paid = $xml->createElement('Paid','false');
                    }
                    $ele_payment->appendChild($ele_payment_paid);


                    $ele_document->appendChild($ele_payments);
                    /************ END PAGAMENTI ************/



                    /************ BEGIN PRODOTTI ************/
                    $ele_prodotti = $xml->createElement('Rows');

                    $items = $the_order->get_items();
                    $ordered_items=array();
                    foreach ($items as $item_key => $item ){
                        $product_id = $item['product_id'];
                        $codice_ordinamento = get_post_meta( $product_id, 'codice_ordinamento', true ).'-'.$item_key.'-'.strtotime("now");
                        $ordered_items[$codice_ordinamento]=$item;
                    }
                    ksort($ordered_items);
                    foreach ( $ordered_items as $item )
                    {
                        $product_name = $item['name'];
                        $product_id = $item['product_id'];
                        $product_qty = round($item['qty'], 3);

                        $product_variation_id = $item['variation_id'];

                        $product = get_post( $product_id);

                        $ele_prodotto = $xml->createElement('Row');
                        $ele_prodotti->appendChild($ele_prodotto);

                        $ele_prodotto_code = $xml->createElement('Code',$product->_sku);
                        $ele_prodotto->appendChild($ele_prodotto_code);
                        $ele_prodotto_description = $xml->createElement('Description',$product_name);
                        $ele_prodotto->appendChild($ele_prodotto_description);
                        $ele_prodotto_quantita = $xml->createElement('Qty', $product_qty);
                        $ele_prodotto->appendChild($ele_prodotto_quantita);
                        $ele_prodotto_price = $xml->createElement('Price', $item['line_total']/$item['qty']);		// prezzo unitario
                        $ele_prodotto->appendChild($ele_prodotto_price);

                        // Movimentazione magazzino
                        $stock_val = get_option('daneawoo_stock', '');
                        if($stock_val == "1")
                            $ele_prodotto_stock = $xml->createElement('Stock', 'true');
                        else
                            $ele_prodotto_stock = $xml->createElement('Stock', 'false');
                        $ele_prodotto->appendChild($ele_prodotto_stock);

                        // COLOR e SIZE	- valutare se parametrizzare il nome dell'attributo che è poi quello che viene usato come nome anche in fase di importazione
                        if(isset($product_variation_id))
                        {
                            $ele_prodotto_size = $xml->createElement('Size', $item['Taglia']);
                            $ele_prodotto->appendChild($ele_prodotto_size);
                            $ele_prodotto_color = $xml->createElement('Color', $item['Colore']);
                            $ele_prodotto->appendChild($ele_prodotto_color);
                        }

                        $ele_prodotto_vat = $xml->createElement('VatCode', $product->_vat);
                        $ele_prodotto->appendChild($ele_prodotto_vat);

                    }

                    $fees = $the_order->get_fees();
                    foreach ($fees as $key => $fee ){
                        $fee_name = $fee['name'];
                        $costo = round($fee['line_total'], 2);
                        $ele_prodotto = $xml->createElement('Row');
                        $ele_prodotti->appendChild($ele_prodotto);

                        $ele_prodotto_description = $xml->createElement('Description',$fee_name);
                        $ele_prodotto->appendChild($ele_prodotto_description);
                        $ele_prodotto_price = $xml->createElement('Price', $costo);		// prezzo unitario

                        $ele_prodotto->appendChild($ele_prodotto_price);

                        // Movimentazione magazzino
                        $stock_val = get_option('daneawoo_stock', '');
                        if($stock_val == "1")
                            $ele_prodotto_stock = $xml->createElement('Stock', 'true');
                        else
                            $ele_prodotto_stock = $xml->createElement('Stock', 'false');
                        $ele_prodotto->appendChild($ele_prodotto_stock);


                        $ele_prodotto_vat = $xml->createElement('VatCode', 'FC');
                        $ele_prodotto->appendChild($ele_prodotto_vat);
                    }
                    $ele_document->appendChild($ele_prodotti);
                    /************ END PRODOTTI ************/
                    wp_reset_query();
                }

                wp_reset_query();


                $ele_easyfattDoc->appendChild($ele_documents);

                $xml->appendChild($ele_easyfattDoc);


                if(isset($_POST['da_pagina']))
                {
                    file_put_contents(VENDIAWOOSYNC_DIR."ordini.xml", $xml->saveXML());
                    echo '<a href="'.VENDIAWOOSYNC_DIR_URL.'ordini.xml" target="_blank">Scarica il file ordini.xml</a>';
                }
                else
                {
                    echo $xml->saveXML();
                }

                die();


            }// chiude if($is_logged)

        }// chiude if(isset($_POST['appver'])

        // se appver non è definito, mostro il form per effettuare lo scarico del file direttamente dal web
        else
        {
            ?>
            <div class="wrap">
                <div class="icon32"><img src="<?php echo VENDIAWOOSYNC_DIR_URL .'inc/icone/icona_plugin_danea_woocommerce_32x32.png' ?>" /><br></div>
                <h2>Download ordini</h2>
                <br />
            <?php
                $this->daneawoo_ordini_imposta_valori();
            ?>
                </div>
            <?php
        }

    }

    public function mostra_pagina_prodotti_svuota()
    {
    ?>
    <h4>Eliminazione di tutti i prodotti</h4>
        <h3>Attenzione! Cliccando il bottone verranno eliminati tutti i prodotti e le categorie associate ai prodotti.</h3>
        <form action="admin.php?page=daneawoo-prodotti-svuota" method="post" name="svuota_prodotti_form" id="svuota_prodotti_form">
            <table class="form-table">
                <tbody>
                    <tr class="form-field">
                        <th scope="row"><label for="delete_categories">Cancellare categorie associate ai vecchi prodotti</label></th>
                        <td>
                            <input type="radio" name="delete_categories" value="1"> Si<br>
                            <input type="radio" name="delete_categories" value="0" checked> No<br>
                        </td>
                    </tr>
                </tbody>
            </table>
            <input type="hidden" id="da_pagina" name="da_pagina" value="si" />
            <p class="submit"><input type="submit" name="svuota_prodotti_button" id="svuota_prodotti_button" class="button button-primary" value="Elimina TUTTI i prodotti"></p>
        </form>
        <?php
    }

    public function daneawoo_prodotti_svuota()
    {
        if(!isset($_POST['da_pagina']))
        {
            $this->mostra_pagina_prodotti_svuota();
        }
        else
        {
            $prod_del = $this->cancellaTuttiIProdotti();
            echo "Sono stati cancellati " . $prod_del . " prodotti";
        }
    }

    public function daneawoo_ordini_imposta_valori()
    {
        ?>
        <h4>Impostare i parametri per filtrare gli ordini. Se nessun parametro è impostato vengono scaricati tutti gli ordini presenti.</h4>
        <form action="admin.php?page=daneawoo-ordini" method="post" name="download_ordini_form" id="download_ordini_form">

        <table class="form-table">
            <tbody>
                <tr class="form-field">
                    <th scope="row"><label for="firstdate">Data minima degli ordini</label></th>
                    <td><input name="firstdate" type="text" id="firstdate" value="" style="width: 130px"> <span class="description">(formato aaaa-mm-gg es. "2013-12-01")</span></td>
                </tr>
                <tr class="form-field">
                    <th scope="row"><label for="lastdate">Data massima degli ordini</label></th>
                    <td><input name="lastdate" type="text" id="lastdate" value="" style="width: 130px"> <span class="description">(formato aaaa-mm-gg es. "2013-12-01")</span></td>
                </tr>
                <tr class="form-field">
                    <th scope="row"><label for="firstnum">Primo nr. ordine da scaricare</label></th>
                    <td><input name="firstnum" type="text" id="firstnum" value="" style="width: 70px"> </td>
                </tr>
                <tr class="form-field">
                    <th scope="row"><label for="lastnum">Ultimo nr. ordine da scaricare</label></th>
                    <td><input name="lastnum" type="text" id="lastnum" value="" style="width: 70px"> </td>

                    <input type="hidden" id="da_pagina" name="da_pagina" value="si" />
                    <input type="hidden" id="appver" name="appver" value="2" />
                </tr>
                <tr class="form-field">
                    <th scope="row"><label for="group_type">Tipo di Gruppo</label></th>
                    <td><select name="group_type" id="group_type" style="width: 70px">
                        <option value="gruppo">GAS referente</option>
                        <option value="gruppo-b">GAS centro</option>
                    </SELECT> </td>
                </tr>
            </tbody>
        </table>

        <p class="submit"><input type="submit" name="download_ordini_button" id="download_ordini_button" class="button button-primary" value="Scarica gli ordini"></p>

        </form>
        <?php
    }

    // crea il filtro per la query per l'estrazione degli ordini
    public function where_ordini( $where = '' )
    {
        global $wpdb;

        if(isset($_POST['firstdate']) && $_POST['firstdate'] != "")
        {
            $firstdate = $_POST['firstdate'];
            $where_sql = $where_sql . " AND post_date >= '" . date('Y-m-d H:i:s', strtotime($firstdate) . " 00:00:01") . "'";
        }
        if(isset($_POST['lastdate']) && $_POST['lastdate'] != "")
        {
            $lastdate = $_POST['lastdate'];
            $where_sql = $where_sql . " AND post_date <= '" . date('Y-m-d H:i:s', strtotime($lastdate . " 23:59:59")) . "'";
        }
        if(isset($_POST['firstnum']) && $_POST['firstnum'] != "")
        {
            $firstnum = $_POST['firstnum'];
            $where_sql = $where_sql . " AND id >= " . $firstnum;
        }
        if(isset($_POST['lastnum']) && $_POST['lastnum'] != "")
        {
            $lastnum = $_POST['lastnum'];
            $where_sql = $where_sql . " AND id <= " . $lastnum;
        }

        $where =  $wpdb->prepare(" AND post_type = %s " . $where_sql,  "shop_order");

        return $where;
    }

    public function importProdotti($file_xml)
    {
        $contenuto_file_xml = utf8_encode(file_get_contents($file_xml["tmp_name"]));
        $xml = simplexml_load_string($contenuto_file_xml);

        $mode = $xml["Mode"];

        // DANEA DICE: Quando l'invio � incrementale (vengono trasmessi solo i nuovi prodotti e quelli modificati o cancellati dall'ultima trasmissione),
        // verranno usate le liste UpdateProducts (per i prodotti da aggiungere o aggiornare) e DeletedProducts (per quelli da eliminare).
        if($mode == "incremental")
        {
            $prodotti_da_aggiornare = count($xml->UpdatedProducts->Product);
            $prodotti_da_cancellare = count($xml->DeletedProducts->Product);

            $xml_updated = 	$xml->UpdatedProducts;
            $xml_deleted = $xml->DeletedProducts;

            $ret_upd = $this->salvaProdotti($xml_updated);
            $ret_del = $this->cancellaProdotti($xml_deleted);
        }
        // DANEA DICE: Quando l'invio � completo (ovvero vengono trasmessi tutti i prodotti), verr� usata esclusivamente la lista Products. � importante provvedere ad eliminare tutti i prodotti presenti nel database del sito ed assenti nella trasmissione
        else
        {
            $prodotti_da_aggiornare = count($xml->Products->Product);

            // cancella i prodotti presenti nel db (NB non tutti i post non presenti ma i post di tipo product (post_type = 'product')
            $this->cancellaTuttiIProdotti();

            $xml_updated = 	$xml->Products;
            $ret_upd = $this->salvaProdotti($xml_updated);
        }

        return $prodotti_da_aggiornare + $prodotti_da_cancellare;
    }

    public function cancellaProdotti($xml_elenco_deleted)
    {
        if(!empty($xml_elenco_deleted) || isset($xml_elenco_deleted))
        {
            foreach($xml_elenco_deleted as $xml_elenco_prodotti_todel)
            {
                $prodotto =  $xml_elenco_prodotti_todel->Product;
                foreach($prodotto as $xml_del_product)
                {
                    $args = array(
                        'post_type' => 'product',
                        'post_status' => 'any',
                        'meta_query' => array(
                            array(
                                'key' => '_sku',
                                'value' => (string)$xml_del_product->Code,
                            )
                        )
                    );
                    $postslist = get_posts( $args );
                    foreach($postslist as $post)
                    {
                        wp_delete_post($post->ID);
                    }
                }
            }
        }
    }

    public function cancellaTuttiIProdotti()
    {
        $postslist = get_posts( array( 'numberposts' => -1, 'post_status' => 'any', 'post_type' => 'product' ) );
        $count_prodotti = 0;
        $inizio = 0;
        $fine = 0;

        foreach($postslist as $post)
        {
            $ret = wp_delete_post($post->ID);		// Set to False if you want to send them to Trash, True for a phisical delete.
            $count_prodotti = $count_prodotti +1;
        }

        if(isset($_POST['delete_categories']) && (int)$_POST['delete_categories'] == true){
            $categories_list = get_terms( array(
                'taxonomy' => 'product_cat',
                'hide_empty' => false,
                'order by' => 'term_id',
            ) );

            foreach($categories_list as $cat)
            {
                wp_delete_term( $cat->term_id, 'product_cat' );
            }
        }

        return $count_prodotti;
    }

    public function salvaProdotti($xml_upd_products)
    {
        $count_prodotti = 0;

        // ATTRIBUTO $article['id'] (es. <article id="1">)
        // VALORE SOTTONODO $article->title (<article id="1"><title>Articolo numero 1</title></article>)
        foreach($xml_upd_products as $xml_elenco_prodotti)
        {
            $prodotto =  $xml_elenco_prodotti->Product;
            foreach($prodotto as $xml_upd_product)
            {
                $category_id = '';
                if(isset($_POST['hierarchical_categories']) && (int)$_POST['hierarchical_categories'] == true){
                    // se ho una sottocategoria, la salvo se non esiste, altrimenti la recupero
                    if(!empty($xml_upd_product->Category))
                    {
                        $category_id = $this->salvaCategoriaProdotto(html_entity_decode(mb_convert_encoding($xml_upd_product->Category, 'Windows-1252', 'UTF-8'), ENT_NOQUOTES, 'Windows-1252'), '');
                    }
                }

                // se ho una sottocategoria, la salvo se non esiste, altrimenti la recupero
                if(!empty($xml_upd_product->Subcategory))
                {
                    $sub_category_id = $this->salvaCategoriaProdotto(html_entity_decode(mb_convert_encoding($xml_upd_product->Subcategory, 'Windows-1252', 'UTF-8'), ENT_NOQUOTES, 'Windows-1252'), $category_id);
                    $cat_for_prodotto = $sub_category_id;
                }

                // $descrizione_html = html_entity_decode(mb_convert_encoding((string)$xml_upd_product->DescriptionHtml, 'Windows-1252', 'UTF-8'), ENT_NOQUOTES, 'Windows-1252');

                // $descrizione_html = str_replace("<b>","<strong>",(string)$xml_upd_product->DescriptionHtml);
                // $descrizione_html = str_replace("&lt;b&gt;","&lt;strong&gt;",(string)$xml_upd_product->DescriptionHtml);
                // $descrizione_html = str_replace("&lt;/b&gt;","&lt;/strong&gt;",$descrizione_html);
                // $descrizione_html = str_replace("&lt;p&gt;","",$descrizione_html);
                // $descrizione_html = str_replace("&lt;/p&gt;","&lt;br/&gt;",$descrizione_html);

                $descrizione_html = html_entity_decode((string)$xml_upd_product->DescriptionHtml, ENT_NOQUOTES);
                $descrizione_html = str_replace("<b>","<strong>",(string)$descrizione_html);
                $descrizione_html = str_replace("</b>","</strong>",$descrizione_html);
                $descrizione_html = str_replace("<p>","",(string)$descrizione_html);
                $descrizione_html = str_replace("</p>","<br/>",$descrizione_html);


                $descrizione_html = str_replace("\r", "",$descrizione_html);
                $descrizione_html = str_replace("\n", "",$descrizione_html);
				
				$descrizione_html = mb_convert_encoding($xml_upd_product->DescriptionHtml, 'Windows-1252', 'UTF-8');

                // $descrizione_html = html_entity_decode(mb_convert_encoding($descrizione_html, 'Windows-1252', 'UTF-8'), ENT_NOQUOTES, 'Windows-1252');
                // $descrizione_per_ricerca_taglie_colori = $descrizione_html;
                // $descrizione_html = preg_replace('/\[daneawoo[^\]]*](.*)\[\/daneawoo[^\]]*]/','', $descrizione_html); // preg_replace è una replace con regular expression

                $pos_p = strpos($descrizione_html,"<br/>");
                // $descrizione_breve = substr($descrizione_html,0,$pos_p+4);
				$descrizione_breve = $descrizione_html;

                $titolo = html_entity_decode(mb_convert_encoding($xml_upd_product->Description, 'Windows-1252', 'UTF-8'), ENT_NOQUOTES, 'Windows-1252');

                // inserisco il prodotto come post
                $post = array(
                'comment_status' => 'closed', 							// 'closed' means no comments.
                'ping_status'    => 'closed', 							// 'closed' means pingbacks or trackbacks turned off
                'post_author'    => 1, 									//The user ID number of the author.
                'post_content'   => $descrizione_html, 					//The full text of the post.
                'post_excerpt'   => $descrizione_breve,
                'post_name'      => str_replace(" ","-", $titolo), 		// The name (slug) for your post
                'post_status'    => 'publish', 							//Set the status of the new post.
                'post_title'     => $titolo, 							//The title of your post.
                'post_type'      => 'product' 							//You may want to insert a regular post, page, link, a menu item or some custom post type
                );

                $product_id = 0;

                // verifico se il prodotto esiste gia'' usando il meta dato _sku che equivale al Code dell'xml
                $args = array(
                    'post_type' => 'product',
                    'meta_query' => array(
                        array(
                            'key' => '_sku',
                            'value' => (string)$xml_upd_product->Code,
                        )
                    )
                );
                $postslist = get_posts( $args );
                if($postslist)
                {
                    foreach($postslist as $post_to_upd)
                    {
                        $product_id = $post_to_upd->ID;
                    }
                }
                // se il prodotto esiste lo modifico
                if(!empty($product_id))
                {
                    // creo un array con l'id del prodotto che mergera' con quello dei dati per passare il tutto alla funzione che salva
                    $post_upd = array('ID' => $product_id);

                    if (!wp_is_post_revision($product_id))
                    {
                        // update the post, which calls save_post again
                        wp_update_post(array_merge($post_upd, $post));
                    }
                }
                else
                {
                    // inserisce il prodotto che e' considerato come un post con post_type = product
                    $product_id = wp_insert_post( $post, $wp_error );
                }
                $wcProduct= wc_get_product( $product_id );
                // associa la categoria al prodotto
                $ret_cat = wp_set_post_terms( $product_id, array($cat_for_prodotto) ,'product_cat');
                if ( is_wp_error($ret_cat) )
                    echo $ret_cat->get_error_message();

                // imposto il prodotto come visibile
                update_post_meta($product_id, '_visibility', 'visible');

                // imposto lo sku (Code)
                update_post_meta($product_id, '_sku', (string)$xml_upd_product->Code);

                // imposto il prezzo "pieno" del prodotto prendendo quale campo selezionare dalle opzioni (GrossPrice4)
                $prezzo = 0;
                switch(get_option('daneawoo_grossprice', ''))
                {
                    case "GrossPrice1":
                        $prezzo = (float)$xml_upd_product->GrossPrice1;
                        break;
                    case "GrossPrice2":
                        $prezzo = (float)$xml_upd_product->GrossPrice2;
                        break;
                    case "GrossPrice3":
                        $prezzo = (float)$xml_upd_product->GrossPrice3;
                        break;
                    case "GrossPrice4":
                        $prezzo = (float)$xml_upd_product->GrossPrice4;
                        break;
                    default:
                        $prezzo = (float)$xml_upd_product->GrossPrice1;
                        break;
                }
                update_post_meta($product_id, '_regular_price', (float)$prezzo);

                // imposto il prezzo
                update_post_meta($product_id, '_price', (float)$prezzo);

                // imposto il codice iva
                update_post_meta($product_id, '_vat', (float)$xml_upd_product->Vat);

                $availableQty=0;
                switch ($xml_upd_product->CustomField2) {
                    case 'sempre a richiesta':
                        $stockLimit=false;
                        break;
                    case 'solo magazzino':
                        $stockLimit=true;
                        $availableQty = (int)$xml_upd_product->AvailableQty;
                        break;
                    default:
                        $stockLimit=true;
                        $availableQty = (int)$xml_upd_product->CustomField2;
                        break;
                }
                try {
                    if(empty($wcProduct)) continue;
                    $this->wcSetStock($wcProduct, $stockLimit, $availableQty);
                } catch (Exception $e) {
                    echo 'Caught exception on '.$titolo.': ',  $e->getMessage(), "\n";
                    error_log('Caught exception on '.$titolo.': ',  $e->getMessage(), "\n") ;
                }



                // // imposto se e' in magazzino o meno valutando la quantita' disponibile del prodotto ed il valore minimo di stocaggio
                // if(
                //     $xml_upd_product->AvailableQty > 0
                //     || (isset($xml_upd_product->MinStock) && $xml_upd_product->AvailableQty >= $xml_upd_product->MinStock)
                //     || ($xml_upd_product->CustomField2=="sempre a richiesta")
                //     || ($xml_upd_product->CustomField2>=1)
                //     )
                // {
                //     // update_post_meta($product_id, '_stock_status', 'instock');
                //     $wcProduct->set_stock_status();
                //     $instock=1;
                // }
                // else
                // {
                //     // update_post_meta($product_id, '_stock_status', 'outofstock');
                //     $wcProduct->set_stock_status("outofstock");
                //     $instock=0;
                // }

                // // imposto la quantita' disponibile (AvailableQty)
                // if(($xml_upd_product->CustomField2=="solo magazzino")||($xml_upd_product->CustomField2=="sempre a richiesta")||$xml_upd_product->CustomField2==""){
                //     // update_post_meta($product_id, '_stock', (int)$xml_upd_product->AvailableQty);
                //     $wcProduct->set_stock_quantity((int)$xml_upd_product->AvailableQty);
                // }
                // else{
                //     // update_post_meta($product_id, '_stock', (int)$xml_upd_product->CustomField2);
                //     $wcProduct->set_stock_quantity((int)$xml_upd_product->CustomField2);
                // }
                // // imposto la proprieta' manage_stock
                // $manage_stock=false;
                // if((bool)(((bool)$xml_upd_product->ManageWarehouse))&&($xml_upd_product->CustomField2!="sempre a richiesta")){

                //     $manage_stock=true;
                //     // update_post_meta($product_id, '_manage_stock', $manage_stock);
                //     $wcProduct->set_manage_stock($manage_stock);
                //     // imposto la proprieta' _backorders
                //     // update_post_meta($product_id, '_backorders', (bool)((((bool)$xml_upd_product->ManageWarehouse))&&($xml_upd_product->CustomField2!="sempre a richiesta")));
                //     $wcProduct->set_backorders($manage_stock?"yes":"no");
                // }


                //imposto codice ordinamento
                update_post_meta($product_id, 'codice_ordinamento', (string)$xml_upd_product->CustomField3);
                // imposto unità di misura
                    update_post_meta($product_id, 'unita_misura', (string)$xml_upd_product->Um);

                // imposto unità di vendita
                    update_post_meta($product_id, 'unita_vendita', (string)$xml_upd_product->CustomField1);

                /*imposto il produttore*/
                update_post_meta($product_id, 'produttore', (string)$xml_upd_product->SupplierCode);

                /**************************************************    TAGS    **************************************************/
                // recupero dalle opzioni il campo contenente i tag
                $campo_tags = "";
                switch(get_option('daneawoo_product_tags', ''))
                {
                    case "1":
                        $campo_tags = $xml_upd_product->CustomField1;
                        break;
                    case "2":
                        $campo_tags = $xml_upd_product->CustomField2;
                        break;
                    case "3":
                        $campo_tags = $xml_upd_product->CustomField3;
                        break;
                    case "4":
                        $campo_tags = $xml_upd_product->CustomField4;
                        break;
                }

                if(!empty($campo_tags))
                {
                    // separo i tags
                    $tags = explode(", ", $campo_tags);
                    foreach($tags as $tag)
                    {
                        $cat_id = intval(term_exists($tag, 'pa_valori-aggiunti'));
                        if ($cat_id !== 0 && $cat_id !== null)
                        {
                            $tag = $cat_id;
                        }
                    }

                    $ret_tag = wp_set_object_terms( $product_id, $tags ,'pa_valori-aggiunti' );
                }
                else
                    $ret_tag = wp_set_object_terms( $product_id, '' ,'pa_valori-aggiunti' );

                // daneawoo_product_custom_field_1
                // Sono considerati come terms con taxonomy = pa_nomecampo perche' cosi' le ho chiamara in woocommerce -> Attributi
                $custom_field_1 = get_option('daneawoo_product_custom_field_1', '');
                if(!empty($custom_field_1))
                {
                    if(!empty($xml_upd_product->CustomField1))
                    {
                        $field_1 = html_entity_decode(mb_convert_encoding($xml_upd_product->CustomField1, 'Windows-1252', 'UTF-8'), ENT_NOQUOTES, 'Windows-1252');
                        $ret_field_1 = wp_set_object_terms( $product_id, array($field_1), 'pa_' . strtolower($custom_field_1));
                        if ( is_wp_error($ret_field_1) )
                            echo $ret_field_1->get_error_message();

                        $attributes_extra[ sanitize_title('pa_' . strtolower($custom_field_1)) ] = array(
                                'name'          => woocommerce_clean('pa_' . strtolower($custom_field_1)),
                                'value'         => '',
                                'position'      => 0,
                                'is_visible'    => 1,
                                'is_variation'  => 0,
                                'is_taxonomy'   => 1
                            );
                    }
                }

                /**************************************************    CUSTOM FIELDS    **************************************************/

                // Sono considerati come terms con taxonomy = pa_nomecampo perche' cosi' le ho chiamara in woocommerce -> Attributi
                $custom_field_2 = get_option('daneawoo_product_custom_field_2', '');
                if(!empty($custom_field_2))
                {
                    if(!empty($xml_upd_product->CustomField2))
                    {
                        $field_2 = html_entity_decode(mb_convert_encoding($xml_upd_product->CustomField2, 'Windows-1252', 'UTF-8'), ENT_NOQUOTES, 'Windows-1252');
                        $ret_field_2 = wp_set_object_terms( $product_id, array($field_2) , 'pa_' . strtolower($custom_field_2));
                        if ( is_wp_error($ret_field_2) )
                            echo $ret_field_2->get_error_message();

                        $attributes_extra[ sanitize_title('pa_' . strtolower($custom_field_2)) ] = array(
                            'name'          => woocommerce_clean('pa_' . strtolower($custom_field_2)),
                            'value'         => '',
                            'position'      => 1,
                            'is_visible'    => 1,
                            'is_variation'  => 0,
                            'is_taxonomy'   => 1
                        );
                    }
                }

                // Sono considerati come terms con taxonomy = pa_nomecampo perche' cosi' le ho chiamara in woocommerce -> Attributi
                $custom_field_3 = get_option('daneawoo_product_custom_field_3', '');
                if(!empty($custom_field_3))
                {
                    if(!empty($xml_upd_product->CustomField3))
                    {
                        $field_3 = html_entity_decode(mb_convert_encoding($xml_upd_product->CustomField3, 'Windows-1252', 'UTF-8'), ENT_NOQUOTES, 'Windows-1252');
                        $ret_field_3 = wp_set_object_terms( $product_id, array($field_3) ,'pa_' . strtolower($custom_field_3));
                        if ( is_wp_error($ret_field_3) )
                            echo $ret_field_3->get_error_message();

                        $attributes_extra[ sanitize_title('pa_' . strtolower($custom_field_3)) ] = array(
                            'name'          => woocommerce_clean('pa_' . strtolower($custom_field_3)),
                            'value'         => '',
                            'position'      => 2,
                            'is_visible'    => 1,
                            'is_variation'  => 0,
                            'is_taxonomy'   => 1
                        );
                    }
                }

                // Sono considerati come terms con taxonomy = pa_nomecampo perche' cosi' le ho chiamara in woocommerce -> Attributi
                $custom_field_4 = get_option('daneawoo_product_custom_field_4', '');
                if(!empty($custom_field_4))
                {
                    if(!empty($xml_upd_product->CustomField4))
                    {
                        $field_4 = html_entity_decode(mb_convert_encoding($xml_upd_product->CustomField4, 'Windows-1252', 'UTF-8'), ENT_NOQUOTES, 'Windows-1252');
                        $ret_field_4 = wp_set_object_terms( $product_id, array($field_4) ,'pa_' . strtolower($custom_field_4));
                        if ( is_wp_error($ret_field_4) )
                            echo $ret_field_4->get_error_message();

                        $attributes_extra[ sanitize_title('pa_' . strtolower($custom_field_4)) ] = array(
                            'name'          => woocommerce_clean('pa_' . strtolower($custom_field_4)),
                            'value'         => '',
                            'position'      => 3,
                            'is_visible'    => 1,
                            'is_variation'  => 0,
                            'is_taxonomy'   => 1
                        );


                    }
                }

                // Link: sono cinsiderata come terms con taxonomy = pa_link perch� cos� le ho chiamara in woocommerce -> Attributi
                if(!empty($xml_upd_product->Link))
                {
                    $ret_link = wp_set_object_terms( $product_id, array($xml_upd_product->Link) ,'pa_link');
                    if ( is_wp_error($ret_link) )
                        echo $ret_link->get_error_message();

                    $attributes_extra[ sanitize_title('pa_link') ] = array(
                        'name'          => woocommerce_clean('pa_link'),
                        'value'         => '',
                        'position'      => 3,
                        'is_visible'    => 1,
                        'is_variation'  => 0,
                        'is_taxonomy'   => 1
                    );
                }

                // Note: sono cinsiderata come terms con taxonomy = pa_note perch� cos� le ho chiamara in woocommerce -> Attributi
                if(!empty($xml_upd_product->Notes))
                {
                    $note = html_entity_decode(mb_convert_encoding($xml_upd_product->Notes, 'Windows-1252', 'UTF-8'), ENT_NOQUOTES, 'Windows-1252');
                    $note = str_replace("\r\n;","&lt;br/&gt;", $note);
                    $ret_note = wp_set_object_terms($product_id, array($note) ,'pa_note');
                    if ( is_wp_error($ret_note) )
                        echo $ret_note->get_error_message();

                    $attributes_extra[ sanitize_title('pa_note') ] = array(
                        'name'          => woocommerce_clean('pa_note'),
                        'value'         => '',
                        'position'      => 4,
                        'is_visible'    => 1,
                        'is_variation'  => 0,
                        'is_taxonomy'   => 1
                    );
                }

                /* CANCELLO LE VARIAZIONI PRE-ESISTENTI */
                $args_variazioni_to_del = array(
                    'post_type' => 'product_variation',
                    'post_parent' => $product_id,
                );
                $postsvariationslist_to_del = get_posts( $args_variazioni_to_del );
                if($postsvariationslist_to_del)
                {
                    foreach($postsvariationslist_to_del as $post_variation_to_del)
                    {
                        wp_delete_post($post_variation_to_del->ID);
                    }
                }

                // ************** GESTIONE COLORI E TAGLIE *******************
                $num_variazione = 0;
                $taglie = '';
                $colori = '';

                if(!empty($xml_upd_product->Variants))
                {
                    // guardo quante variazione del prodotto ho
                    $variazioni = $xml_upd_product->Variants;

                    foreach($variazioni->Variant as $variazione)
                    {
                        // se la variazione ha una quantita' disponibile allora inserico la variazione come product_variation
                        if(!empty($variazione->AvailableQty) && (int)$variazione->AvailableQty > 0)
                        {
                            // controllo se esiste gia' la variazione per il prodotto
                            $product_variation_id = 0;

                            $args_variazioni = array(
                                'post_type' => 'product_variation',
                                'post_parent' => $product_id,
                                'meta_query' => array(
                                    array(
                                        'key' => 'attribute_taglia',
                                        'value' => (string)$variazione->Size
                                    ), array (
                                        'key' => 'attribute_colore',
                                        'value' => (string)$variazione->Color,
                                    )
                                )
                            );
                            $postsvariationslist = get_posts( $args_variazioni );
                            if($postsvariationslist)
                            {
                                foreach($postsvariationslist as $post_variation_to_upd)
                                {
                                    $product_variation_id = $post_variation_to_upd->ID;
                                }
                            }

                            // CREAZIONE VARIAZIONE
                            // se la variazione del prodotto non esiste la inserisco come un post con post_type = product_variation
                            $product_variation_id = $this->creaVariazioneProdotto($product_id, $product_variation_id, $num_variazione);
                            $num_variazione = $num_variazione +1;

                            // imposto la quantita' disponibile (AvailableQty)
                            update_post_meta($product_variation_id, '_stock', (int)$variazione->AvailableQty);

                            // imposto la taglia (Size)
                            update_post_meta($product_variation_id, 'attribute_taglia', (string)$variazione->Size);

                            // imposto il colore (Color)
                            update_post_meta($product_variation_id, 'attribute_colore', (string)$variazione->Color);

                            // imposto il Barcode (Barcode)
                            update_post_meta($product_variation_id, 'attribute_variazione_barcode', (string)$variazione->Barcode);

                            // imposto il prezzo "pieno" del prodotto (GrossPrice4) preso dal prodotto perch� Danea non permette di impostarlo diverso
                            update_post_meta($product_variation_id, '_regular_price', (float)$prezzo);

                            // imposto il prezzo preso dal prodotto perche' Danea non permette di impostarlo diverso
                            update_post_meta($product_variation_id, '_price', (float)$prezzo);

                            // salvo tutte le stringhe taglie e colori disponibili per inserirle come attributi nel post padre
                            if(!empty($variazione->Size))
                            {
                                if($taglie != '')
                                {
                                    $pos_taglia = strpos($taglie, (string)$variazione->Size);
                                    if ($pos_taglia === false)
                                        $taglie =  $taglie . "|" . (string)$variazione->Size;
                                }
                                else
                                    $taglie = $taglie . (string)$variazione->Size;
                            }

                            if(!empty($variazione->Color))
                            {
                                if($colori != '')
                                {
                                    $pos_colore = strpos($colori, (string)$variazione->Color);
                                    if ($pos_colore === false)
                                        $colori = $colori. "|" . (string)$variazione->Color;
                                }
                                else
                                    $colori = $colori . (string)$variazione->Color;
                            }

                            // aggiungo il meta dato che identifica questa coppie taglia colore come predefinita
                            if($num_variazione==1)
                            {
                                $attributes_default = array(
                                'taglia'          => (string)$variazione->Size,
                                'colore'         => (string)$variazione->Color
                                );

                                update_post_meta( $product_id, '_default_attributes', $attributes_default );
                            }
                        }
                    }	// chiude foreach variazioni

                }	// chiude Variant

                // ************** GESTIONE COLORI E TAGLIE - DA DESCRIZIONE HTML *******************
                // provo a vedere se nella descrizione del prodotto è stato inserito uno schortcode che gestisce le taglie del tipo [daneawoo taglie="S|M|L" colori="Azzurro|Rosso" quantità="4"][daneawoo taglie="L" colori="Bianco" quantità="1"]
                preg_match_all('/\[daneawoo[^\]]*](.*)\[\/daneawoo[^\]]*]/',$descrizione_per_ricerca_taglie_colori,$matches); // $matches[0][0]: matrice con tutti gli shortcode presenti $matches[0][1]: shortcode successivo

                for ($i=0; $i < count($matches); $i++)
                {
                    for ($j=0; $j < count($matches[$i]); $j++)
                    {
                        preg_match_all('/".*?"/', $matches[$i][$j], $matchesTaglieColori);

                        $quantitaDaDescr = str_replace("\"","",$matchesTaglieColori[0][2]); // "5" -> 5
                        $taglieDaDescr = split("\|",str_replace("\"","",$matchesTaglieColori[0][0]));	// "S|M" -> S M
                        $coloriDaDescr = split("\|",str_replace("\"","",$matchesTaglieColori[0][1])); // "Blu|Bianco" -> Blu Bianco

                        if(!empty($quantitaDaDescr) && (int)$quantitaDaDescr > 0)
                        {
                            foreach($taglieDaDescr as $tagliaDaDescr)
                            {
                                if(!empty($tagliaDaDescr))
                                {
                                    foreach($coloriDaDescr as $coloreDaDescr)
                                    {
                                        if(!empty($coloreDaDescr))
                                        {
                                            // controllo se esiste gia' la variazione per il prodotto
                                            $product_variation_id = 0;

                                            $args_variazioni = array(
                                                'post_type' => 'product_variation',
                                                'post_parent' => $product_id,
                                                'meta_query' => array(
                                                    array(
                                                        'key' => 'attribute_taglia',
                                                        'value' => (string)$tagliaDaDescr
                                                    ), array (
                                                        'key' => 'attribute_colore',
                                                        'value' => (string)$coloreDaDescr,
                                                    )
                                                )
                                            );
                                            $product_variation_id = 0;
                                            $postsvariationslist = get_posts( $args_variazioni );
                                            if($postsvariationslist)
                                            {
                                                foreach($postsvariationslist as $post_variation_to_upd)
                                                {
                                                    $product_variation_id = $post_variation_to_upd->ID;
                                                }
                                            }

                                            $product_variation_id = $this->creaVariazioneProdotto($product_id, $product_variation_id, $num_variazione);
                                            $num_variazione = $num_variazione +1;

                                            // imposto la quantita' disponibile (AvailableQty)
                                            update_post_meta($product_variation_id, '_stock', (int)$quantitaDaDescr);

                                            // imposto la taglia (Size)
                                            update_post_meta($product_variation_id, 'attribute_taglia', (string)$tagliaDaDescr);

                                            // imposto il colore (Color)
                                            update_post_meta($product_variation_id, 'attribute_colore', (string)$coloreDaDescr);

                                            // imposto il prezzo "pieno" del prodotto (GrossPrice4) preso dal prodotto perch� Danea non permette di impostarlo diverso
                                            update_post_meta($product_variation_id, '_regular_price', (float)$prezzo);

                                            // imposto il prezzo preso dal prodotto perche' Danea non permette di impostarlo diverso
                                            update_post_meta($product_variation_id, '_price', (float)$prezzo);

                                            // salvo tutte le stringhe taglie e colori disponibili per inserirle come attributi nel post padre
                                            if(!empty($tagliaDaDescr))
                                            {
                                                if($taglie != '')
                                                {
                                                    $pos_taglia = strpos($taglie, (string)$tagliaDaDescr);
                                                    if ($pos_taglia === false)
                                                        $taglie =  $taglie . "|" . (string)$tagliaDaDescr;
                                                }
                                                else
                                                    $taglie = $taglie . (string)$tagliaDaDescr;
                                            }

                                            if(!empty($coloreDaDescr))
                                            {
                                                if($colori != '')
                                                {
                                                    $pos_colore = strpos($colori, (string)$coloreDaDescr);
                                                    if ($pos_colore === false)
                                                        $colori = $colori. "|" . (string)$coloreDaDescr;
                                                }
                                                else
                                                    $colori = $colori . (string)$coloreDaDescr;
                                            }

                                            // aggiungo il meta dato che identifica questa coppie taglia colore come predefinita
                                            if($num_variazione==1)
                                            {
                                                $attributes_default = array(
                                                'taglia'          => (string)$tagliaDaDescr,
                                                'colore'         => (string)$coloreDaDescr
                                                );

                                                update_post_meta( $product_id, '_default_attributes', $attributes_default );
                                            }

                                        } // chiude is isempty colore

                                    } // chiude foreach colore

                                } // chiude if isempty taglia
                            } // chiude foreach taglia

                        } // chiude if isempty quantita
                    } // chiude for count $j
                } // chiude for descrizione_html con taglie colori


                if( (!empty($taglie)) || (!empty($colori)))
                {
                    $ret_note = wp_set_object_terms( $product_id, array('variable') ,'product_type');
                }

                // se ci sono taglie e colori li associo al prodotto base come Attributi
                if(!empty($taglie))
                {
                    // per attivare la taglia bisogna inserirla tra gli attrubiti del prodotto "padre"
                    $attributes_extra[ sanitize_title('Taglia') ] = array(
                    'name'          => woocommerce_clean('Taglia'),
                    'value'         => $taglie,
                    'position'      => 5,
                    'is_visible'    => 1,
                    'is_variation'  => 1,
                    'is_taxonomy'   => 0
                    );
                }

                if(!empty($colori))
                {
                    // per attivare i colori bisogna intanto inserirli tra gli attrubiti del prodotto "padre"
                    $attributes_extra[ sanitize_title('Colore') ] = array(
                    'name'          => woocommerce_clean('Colore'),
                    'value'         => $colori,
                    'position'      => 6,
                    'is_visible'    => 1,
                    'is_variation'  => 1,
                    'is_taxonomy'   => 0
                    );
                }


                if(isset($attributes_extra))
                {
                    // adesso inserisco l'array degli attributi che sono le informazioni aggiuntive del prodotto dentro la tabella postmeta secondo una codifica che si costruisce da solo
                    if(!function_exists('attributes_cmp'))
                    {
                        function attributes_cmp($a, $b)
                        {
                            if ( $a['position'] == $b['position'] ) return 0;
                            return ( $a['position'] < $b['position'] ) ? -1 : 1;
                        }
                    }
                    uasort( $attributes_extra, 'attributes_cmp' );

                    update_post_meta( $product_id, '_product_attributes', $attributes_extra );
                    unset($attributes_extra);
                    unset($colori);
                    unset($taglie);
                }

                $product_description=''
                .';n:'.$count_prodotti
                .';nomep='.$titolo
                .';prod_id='.$product_id
                .';instock='.$instock
                .';manage_stock='.$manage_stock
                .'\n';
                error_log($product_description);
                $count_prodotti = $count_prodotti + 1;
            }
        }



    }

    public function wcSetStock($wcProduct, bool $stockLimit, int $availableQty=0){
        $wcProduct->set_stock_quantity(0);
        $wcProduct->set_backorders("no");
        $wcProduct->set_manage_stock(false);
        $wcProduct->set_stock_status("outofstock");
        $wcProduct->save();
        $wcProduct->set_stock_status('instock');

        if($stockLimit && $availableQty==0){
            $wcProduct->set_stock_status("outofstock");
        }

        if($stockLimit && $availableQty>0){
            $wcProduct->set_manage_stock(true);
            $wcProduct->set_stock_quantity($availableQty);
        }
        $wcProduct->save();
        return;
    }

    // crea per il prodotto indicatto la variazione per le taglie/colori
    public function creaVariazioneProdotto($product_id, $product_variation_id, $num_variazione)
    {
        // CREAZIONE VARIAZIONE
        // se la variazione del prodotto non esiste la inserisco come un post con post_type = product_variation
        if($product_variation_id==0)
        {
            if($num_variazione==0)
                $n_var = '';
            else
                $n_var = $num_variazione+1;

            $post_variation_title = 'Variazione ### di '. $titolo;

            // inserisco il prodotto come post
            $post_variation = array(
            'comment_status' => 'closed', 													// 'closed' means no comments.
            'ping_status'    => 'closed', 													// 'closed' means pingbacks or trackbacks turned off
            'post_author'    => 2, 															//The user ID number of the author.
            'post_name'      => 'product-' . $product_id . '-variation-' . $n_var, 			// The name (slug) for your post
            'post_status'    => 'publish', 													//Set the status of the new post.
            'post_title'     => $post_variation_title, 										//The title of your post.
            'post_type'      => 'product_variation',
            'post_parent'    => $product_id
            );

            $product_variation_id = wp_insert_post( $post_variation, $wp_error );

            $post_variation_upd  = array(
                'ID' => $product_variation_id,
                'post_title'  => str_replace('###', '#' . $product_variation_id,  $post_variation_title)
            );

            if (!wp_is_post_revision($product_variation_id))
            {
                // imposto il post_titolo definitivo
                wp_update_post($post_variation_upd);
            }
        }

        return $product_variation_id;
    }

    public function salvaImmagine($product_id, $filename)
    {
        if(!empty( $filename ))
        {
            $wp_filetype = wp_check_filetype(basename($filename), null );

            $prodotto = get_post($product_id);
            $nome_prodotto = $prodotto->post_name;
            $nome_immagine = basename($nome_prodotto) . "." . $wp_filetype['ext'];

            // verifico che non ci sia gi� il posto di tipo attachment associato a questo prodotto perch� anvente lo stesso titolo
            $args_img = array(
                'post_type' => 'attachment',
                'post_parent' => $product_id,
                'post_title' => $nome_immagine,
                'guid' => 'images/products/' . '/' . $nome_immagine
            );
            $postslistimages = get_posts($args_img);

            if(!$postslistimages)
            {
                $attachment = array(
                    'guid' => 'images/products/' . '/' . $nome_immagine,
                    'post_mime_type' => $wp_filetype['type'],
                    'post_title' => preg_replace('/\.[^.]+$/', '', $nome_immagine),
                    'post_content' => '',
                    'post_status' => 'inherit'
                );

                // PERCORSO Dove caricare le immagini dei prodotti: http://www.lagallinacubista.it/wp-content/uploads/images/products/
                $attach_id = wp_insert_attachment($attachment, ABSPATH . 'wp-content/uploadsimages/products/'. $nome_immagine, $product_id);

                // you must first include the image.php file for the function wp_generate_attachment_metadata() to work
                require_once(ABSPATH . 'wp-admin/includes/image.php');
                $attach_data = wp_generate_attachment_metadata( $attach_id,  ABSPATH . 'wp-content/uploads/images/products/' . $nome_immagine );
                wp_update_attachment_metadata( $attach_id, $attach_data );

                // associo il thumbnail al prodotto
                update_post_meta($product_id, '_thumbnail_id', $attach_id);
            }
        }
    }

    // verifico se esiste la categoria altrimenti la inserisco
    public function salvaCategoriaProdotto($category, $category_parent)
    {
        // restituisce: 0 if the term does not exist. the term ID if no taxonomy was specified and the term exists.
        // An array if the pairing exists. (format: array('term_id'=>term id, 'term_taxonomy_id'=>taxonomy id))
        $c_id = term_exists($category, 'product_cat');

        if ($c_id == 0 || $c_id == null)
        {
            $cat = array(
                'cat_name' => $category,
                'category_description' => $category,
                'category_nicename' => str_replace(" ","-", $category),
                'category_parent' => $category_parent,
                'taxonomy' => 'product_cat'
            );

            // Create the category
            $c_id = wp_insert_category($cat);
            $cat_id = (int)$c_id;
        }
        else
        {
            $cat_id = $c_id['term_id'];
        }
        return $cat_id;
    }

    public function verificaCredenzialiDanea()
    {

        // verifico le credenziali
        if ( (isset($_SERVER["HTTP_X_AUTHORIZATION"])) && base64_decode($_SERVER["HTTP_X_AUTHORIZATION"]) != "")
        {
            $is_logged = $this->autenticaUtenteDanea(base64_decode($_SERVER["HTTP_X_AUTHORIZATION"]));
            if($is_logged)
            {
                return true;
            }
            else
                return false;
        }
        else
            return false;
    }

    public function autenticaUtenteDanea($http_x_authorization)
    {
        $username_pw = explode(":", $http_x_authorization);
        $username = $username_pw[0];
        $password = $username_pw[1];

        $ret_user = wp_authenticate($username, $password);
        if(is_wp_error($ret_user))
            echo "errore autenticazione";

        wp_set_current_user($ret_user->ID, $username);
        wp_set_auth_cookie($ret_user->ID);
        do_action('wp_login', $username);

        if( 0 == $ret_user->ID)
        {
            // Not logged in
            return false;
        }
        else
        {
            // Logged in.
            if(is_super_admin($ret_user->ID))
            {
                return true;
            }
            else
            {
                // non suepr admin
                return false;
            }
            // return true;
        }
    }

}