<?php
class EW_Code{

	/**
	 * Reimposta la coda del servizio selezionato
	 * @return bool //IsOk
	 */
	function reset_coda($id_servizio){
		//imposta a 0 il numero stampato e servito
		update_post_meta( $id_servizio, 'ultimo_servito', 0 );
		update_post_meta( $id_servizio, 'ultimo_stampato', 0 );
		return true;
	}
	
	/**
	 * Incrementa il numero ticket stampati per il servizio selezionato
	 * @return int $da_stampare
	 */
	function incrementa_stampato($id_servizio){
		// incrementa lo stampato di 1
		$stampato_attuale = get_post_meta( $id_servizio, 'ultimo_stampato',true );
		$da_stampare = $stampato_attuale+1;
		update_post_meta( $id_servizio, 'ultimo_stampato', $da_stampare );
		// Configura per il conteggio tempi medi
		$stima_media_ultimo_stampato = get_post_meta( $id_servizio, 'stima_media_ultimo_stampato',true );
		if (!$stima_media_ultimo_stampato){
			update_post_meta( $id_servizio, 'stima_media_ultimo_stampato', $da_stampare );
			$ora_attuale=time();
			update_post_meta( $id_servizio, 'stima_media_ora_ultimo_stampato', $ora_attuale);
		}
		// restituisci il numero stampato
		return $da_stampare;
	}
		
	/**
	 * Incrementa il numero ticket serviti per il servizio selezionato
	 * @return multi [int $da_servire | false se = da servire]
	 */
	function incrementa_servito($id_servizio){
		//incrementa il servito di 1
		$servito_attuale = get_post_meta( $id_servizio, 'ultimo_servito',true );
		$da_servire = $servito_attuale+1;
		update_post_meta( $id_servizio, 'ultimo_servito', $da_servire );
		// Configura per il conteggio tempi medi
		$stima_media_ultimo_stampato = get_post_meta( $id_servizio, 'stima_media_ultimo_stampato',true );
		if ($stima_media_ultimo_stampato==$da_servire){
			$stima_media_ora_ultimo_stampato = get_post_meta( $id_servizio, 'stima_media_ora_ultimo_stampato',true );
			$ora_attuale = time();
			$tempo_evasione = $ora_attuale - $stima_media_ora_ultimo_stampato;
			$stima_media_conteggio_numeri = get_post_meta( $id_servizio, 'stima_media_conteggio_numeri',true );
			$stima_media_conteggio_numeri += 1;
			$stima_media_tempo_totale = get_post_meta( $id_servizio, 'stima_media_tempo_totale',true );
			$stima_media_tempo_totale += $tempo_evasione;
			$stima_media_tempo_medio = $stima_media_tempo_totale / $stima_media_conteggio_numeri;
			$stima_media_tempo_medio = (int)$stima_media_tempo_medio;
			
			update_post_meta( $id_servizio, 'stima_media_conteggio_numeri', $stima_media_conteggio_numeri );
			update_post_meta( $id_servizio, 'stima_media_ultimo_stampato', 0 );
			update_post_meta( $id_servizio, 'stima_media_tempo_totale', $stima_media_tempo_totale );
			update_post_meta( $id_servizio, 'stima_media_tempo_medio', $stima_media_tempo_medio );
		}
		//restituisci il numero servito
		return $da_servire;
	}
	
	/**
	 * Serve il primo ticket disponibile per il servizio selezionato presso lo sportello indicato
	 * @return array [id_servizio, id_sportello, numero_servito]
	 */
	function servi_servizio($id_servizio, $id_sportello){
		//incrementa il numero servito per il servizio indicato
		$numero_servito = &$this->incrementa_servito($id_servizio);
		//salva nello storico l'associazione [sportello+servizio+numero_servito]
		//TODO
		
		$nome_sportello = get_the_title( $id_sportello, 'post_title', true );
		$sigla_servizio = get_post_meta( $id_servizio, 'sigla_servizio',true );
		
		$my_post = array(
			'post_title' => $nome_sportello.'-'.$sigla_servizio.$numero_servito,
			'post_status' => 'publish',
			'post_type' => 'storico_coda' );
		
		// global $post_data;
		// $post_data = array(
			// 'post_type' => 'storico_coda',
			// 'sportello' => $id_sportello,
			// 'servizio' => $id_servizio,
			// 'numero' => $numero_servito );
		// Insert the post into the database
		$storico_id = wp_insert_post($my_post);
		//restituisci id_servizio, id_sportello, numero_servito
		
		add_post_meta($storico_id, 'sportello', $id_sportello);
		add_post_meta($storico_id, 'servizio', $id_servizio);
		add_post_meta($storico_id, 'numero', $numero_servito);
		
		
		$servito = array(
				'id_sportello' => get_the_title( $id_sportello, 'post_title', true ),
				'sigla_servizio' => get_post_meta( $id_servizio, 'sigla_servizio',true ),
				'numero_servito' => $numero_servito
			);
		return $servito;
	}
	
	/**
	 * Serve il primo ticket disponibile presso lo sportello selezionato
	 * @return array [id_servizio, id_sportello, numero_servito]
	 */
	function servi_sportello($id_sportello){
		
		//prendi l'id_servizio dall'elenco servizi associati e guarda il primo servizio che ha ancora persone in coda
		//prendo la lista dei servizi associati
		//$servizi_erogati = get_post_meta( $id_servizio, 'servizi_erogati',true );
		// $servizi_erogati = get_post_custom_values('servizi_erogati', $id_sportello);
		$servizi_erogati = get_field('servizi_erogati', $id_sportello);
		if( $servizi_erogati ){
			foreach ( $servizi_erogati as $servizio_erogato ) {
				//echo "$key  => $servizio ('my_key')<br />"; 
				$servito_attuale = 0;
				$stampato_attuale = 0;
				$servito_attuale = get_post_meta( $servizio_erogato->ID, 'ultimo_servito',true );
				$stampato_attuale = get_post_meta( $servizio_erogato->ID, 'ultimo_stampato', true );
				if($servito_attuale<$stampato_attuale){
					//servi il servizio trovato
					$servito = &$this->servi_servizio($servizio_erogato->ID, $id_sportello);
					//aggiungi il numero servito anche alla cache dello sportello (per velocizzare la chiamata dal monitor)
					update_field('ultimo_servito', $servito['sigla_servizio'].$servito['numero_servito'], $id_sportello);
					
					// aggiorno il servizio per prendere l'evento dai pannelli operatori
					$my_post = array(
						'ID'           => $servizio_erogato->ID,
					);
					wp_update_post( $my_post );
					
					return $servito;
					// return $servito_attuale.' di '.$stampato_attuale;
				}
			}
			return array('fine_coda' => 'Coda terminata');
		}
	}
	
	/**
	 * Reimposta la coda di tutti i servizi
	 * @return bool //IsOk
	 */
	function reset_code(){
		//prendi l'elenco dei servizi
			$args = array(
				'post_type' => 'servizi',
				'post_status' => 'publish'
			); 
			$servizi = get_posts($args);
		//per ogni servizio fai reset
		$servizi_resettati='';
		foreach ( $servizi as $servizio ) {
			$id_servizio = $servizio->ID; //prendo l'ID del servizio
			$is_resettato = &$this->reset_coda($id_servizio);
			$servizi_resettati .= $id_servizio.',';
		}
					// return true;
			return $servizi_resettati;
	}
	
	/**
	 * Incrementa il numero nella coda del servizio indicato, restituisce il codice da stampare
	 * @return string $codice_da_stampare
	 */
	function stampa_nuovo($id_servizio){
		$da_stampare = &$this->incrementa_stampato($id_servizio);
		$sigla_servizio = get_post_meta( $id_servizio, 'sigla_servizio',true );
		$codice_da_stampare = $sigla_servizio.$da_stampare;
		
		// aggiorno il servizio per prendere l'evento dai pannelli operatori
		$my_post = array(
			'ID'           => $id_servizio,
		);
		wp_update_post( $my_post );
		
		return $codice_da_stampare;
	}
	
	/**
	 * Indica numero di richieste da evadere per il servizio indicato
	 * @return int $numeri_mancanti
	 */
	function numeri_mancanti($id_servizio){
		$ultimo_servito = get_post_meta( $id_servizio, 'ultimo_servito',true );
		$ultimo_stampato = get_post_meta( $id_servizio, 'ultimo_stampato',true );
		$numeri_mancanti = $ultimo_stampato - $ultimo_servito;
		return $numeri_mancanti;
	}
}