<?php
// include('classes/management.php'); //Management page
if(!class_exists('EW_Anti_Code_Management'))
{
	class EW_Anti_Code_Management
	{
		
		/**
		 * Construct the plugin object
		 */
		public function __construct()
		{
			// register actions
			
			//Admin actions
            add_action('admin_init', array(&$this, 'admin_init'));
        	add_action('admin_menu', array(&$this, 'add_menu'));
			// Ajax actions
			add_action('wp_ajax_ajax_plugin_management', array(&$this, 'ajax_plugin_management'));
			add_action('wp_ajax_nopriv_ajax_plugin_management', array(&$this, 'ajax_plugin_management')); // Public access
		} // END public function __construct
		
        /**
         * hook into WP's admin_init action hook
         */
        public function admin_init()
        {
        	// No need of settings
            // Possibly do additional admin_init tasks
        } // END public static function activate
        
        /**
         * add a menu
         */		
        public function add_menu()
        {
            // Add a page to manage this plugin's settings
        	add_management_page(
        	    'Anti Coda', 
        	    'Anti Coda', 
        	    'manage_options', 
        	    'ew_anti_coda', 
        	    array(&$this, 'plugin_management_page')
        	);
        } // END public function add_menu()
    
        /**
         * Menu Callback
         */		
        public function plugin_management_page()
        {
        	if(!current_user_can('manage_options'))
        	{
        		wp_die(__('You do not have sufficient permissions to access this page.'));
        	}
			
			global $ultima_stampa;
			global $ultima_servito;
			global $resettati;
			
			// Verify that the incoming request is coming with the security nonce
			// if( wp_verify_nonce( $_REQUEST['nonce'], 'ajax_plugin_management' ) ) {
				
				// chiama funzione di switch dei _POST e gestore funzioni
				$post_switch_engine = &$this->post_switch_engine();
				
				if ( isset($_POST['esegui']) ){
					switch($_POST['esegui']) {
						case "stampa_biglietto":
							if ( isset($_POST['servizio']) && ($_POST['servizio']!='')):
								$ultima_stampa = ' - Ultima stampa: '.$ultima_stampa;
							endif;
							break;
						case "servi_sportello":
							if ( isset($_POST['sportello']) && ($_POST['sportello']!='')):
								$ultima_servito = ' - Ultimo servito: '.$ultima_servito['sigla_servizio'].$ultima_servito['numero_servito'];;
							endif;
							break;
						case "reset_code":
							$resettati = ' Resettati: '.$resettati;
							break;
					}
				}			
			
			
        	// Render the management template
        	include(sprintf("%s/../templates/management.php", dirname(__FILE__)));
        } // END public function plugin_settings_page()

        /**
         * _POST value switch
         */		
		public function post_switch_engine(){
			global $ultima_stampa;
			global $ultima_servito;
			global $resettati;
			global $numeri_mancanti;
			
			
			$ew_code = new EW_Code();
			if ( isset($_POST['esegui']) ){
				switch($_POST['esegui']) {
					case "stampa_biglietto":
						if ( isset($_POST['servizio']) && ($_POST['servizio']!='')):
							// $testo_prova = 'biglietto '.$_POST['servizio'];
							$ultima_stampa = $ew_code->stampa_nuovo($_POST['servizio']);
							// $ultima_stampa = ' - Ultima stampa: '.$ultima_stampa;
							// $testo_prova = $testo_prova.'+'.$testo2;
							
							//TODO inserire chiamata a cmd locale
								$header_servizio = get_post_meta( $_POST['servizio'], 'header_servizio',true );
								$footer_servizio = get_post_meta( $_POST['servizio'], 'footer_servizio',true );
								// session_write_close();
								// $cmd = escapeshellarg("C:\anticoda\STAMPA.CMD");
								$cmd = "C:\\anticoda\\STAMPA.CMD";
								$cmd = $cmd." ".$ultima_stampa." ".escapeshellarg($footer_servizio)." ".escapeshellarg($header_servizio);
								exec($cmd);
								// $tmp = pclose(popen( 'start /B cmd /S /C ""C:\\anticoda\\STAMPA.CMD""', 'r'));
								// session_start();
							
						endif;
						break;
					case "servi_sportello":
						if ( isset($_POST['sportello']) && ($_POST['sportello']!='')):
							$ultima_servito = $ew_code->servi_sportello($_POST['sportello']);
							// $ultima_servito = implode(",", $ultima_servito);
							// $ultima_servito = ' - Ultimo servito: '.$ultima_servito;
							// $testo_prova = 'servi '.$_POST['sportello'];
						endif;
						break;
					case "reset_code":
						$resettati = $ew_code->reset_code();
						break;
					case "mancanti_servizio":
						if ( isset($_POST['servizio']) && ($_POST['servizio']!='')):
							$numeri_mancanti= $ew_code->numeri_mancanti($_POST['servizio']);
						endif;
						break;
				}
			}
		
		}

		public function ajax_plugin_management(){
			global $ultima_stampa;
			global $ultima_servito;
			global $resettati;
			global $numeri_mancanti;
			
			// Verify that the incoming request is coming with the security nonce
			// if( wp_verify_nonce( $_REQUEST['nonce'], 'ajax_plugin_management' ) ) {
				
				// chiama funzione di switch dei _POST e gestore funzioni
				$post_switch_engine = &$this->post_switch_engine();
				
				if ( isset($_POST['esegui']) ){
					switch($_POST['esegui']) {
						case "stampa_biglietto":
							if ( isset($_POST['servizio']) && ($_POST['servizio']!='')):
								// echo $ultima_stampa;
								// echo implode(",", $_POST);
								$header_servizio = get_post_meta( $_POST['servizio'], 'header_servizio',true );
								$footer_servizio = get_post_meta( $_POST['servizio'], 'footer_servizio',true );
								$return = array(
									'id_servizio'	=> $_POST['servizio'],
									'header_servizio'	=> $header_servizio,
									'ultima_stampa'	=> $ultima_stampa,
									'footer_servizio'	=> $footer_servizio
								);
								
								wp_send_json($return);
								
							endif;
							break;
						case "servi_sportello":
							if ( isset($_POST['sportello']) && ($_POST['sportello']!='')):
								// 'id_sportello' 
								// 'sigla_servizio' 
								// 'numero_servito' 
								echo $ultima_servito['sigla_servizio'].$ultima_servito['numero_servito'];
							endif;
							break;
						case "reset_code":
							echo $resettati;
							break;
						case "mancanti_servizio":
							echo $numeri_mancanti;
							break;
						case "mancanti_servizio2":
							// if ( isset($_POST['servizi']) && ($_POST['servizi']!='')):
								// $servizi = explode(",", $_POST['servizi']);
								// $numeri_mancanti="";
								// foreach( $servizi as $servizio){
									// $numeri_mancanti= $numeri_mancanti.$servizio."-".$ew_code->numeri_mancanti($servizio).",";
								// }
							// endif;
							
							$GLOBALS['now_today'] = '5 second ago';
							
							// Crea una nuova funzione di filtraggio che aggiunga una clausola where alla query
							function filter_where( $where = '' ) {
								// posts in the last 30 days
								$where .= " AND post_modified > '" . date('Y-m-d H:i:s', strtotime($GLOBALS['now_today'])) . "'";
								return $where;
							};
							$args = array(
								'post_type'=>'servizi',
							);
							$ultimo_modificato ='';
							while($ultimo_servito==''){
								add_filter( 'posts_where', 'filter_where' );
								$servizi_query = new WP_Query( $args );
								remove_filter( 'posts_where', 'filter_where' );
								if ($servizi_query->have_posts()){
									$servizi_query->the_post();
									$id_servizio = the_ID();
									$ultimo_servito = get_post_meta( $id_servizio, 'ultimo_servito',true );
									$ultimo_stampato = get_post_meta( $id_servizio, 'ultimo_stampato',true );
									$ultimo_servito = get_field('ultimo_servito', $id_servizio);
									$ultimo_stampato = get_field('ultimo_stampato', $id_servizio);
									$numeri_mancanti = $ultimo_stampato - $ultimo_servito;
									echo $id_servizio."-".$numeri_mancanti;
									die();
								}
								sleep(1);
							}
							break;
						
						
						
						case "ultimo_storico":
							if ( isset($_POST['sportello']) && ($_POST['sportello']!='')):
								
								// // Versione con richiamo delle informazioni in cache nello sportello
								// $ultimo_servito = get_field('ultimo_servito', $_POST['sportello']);
								
								if ( isset($_POST['ultimo_chiamato']) && ($_POST['ultimo_chiamato']!=''))$ultimo_chiamato=$_POST['ultimo_chiamato'];
								$ultimo_servito = get_field('ultimo_servito', $_POST['sportello']);
								while($ultimo_servito==$ultimo_chiamato){
								sleep(2);
								$ultimo_servito = get_field('ultimo_servito', $_POST['sportello']);
								}
								echo $ultimo_servito;
							endif;
							break;
						case "ultimo_storico2":
							$GLOBALS['now_today'] = '5 second ago';
							
							// Crea una nuova funzione di filtraggio che aggiunga una clausola where alla query
							function filter_where( $where = '' ) {
								// posts in the last 30 days
								$where .= " AND post_date > '" . date('Y-m-d H:i:s', strtotime($GLOBALS['now_today'])) . "'";
								return $where;
							};


							// $now_today = getdate();							
							$args = array(
								// 'date_query' => array(
									// array(
										// 'column' => 'post_date_gmt',
										// 'after'  => 'October 4th, 2013'
										// // 'after'    => array(
											// // 'year'  => 2013,
											// // 'month' => 10,
											// // 'day'   => 4,
											// // // 'year'  => $now_today["year"],
											// // // 'month' => $now_today["mon"],
											// // // 'day'   => $now_today["mday"],
											// // // 'hour'  => $now_today["hours"],
											// // // 'minute'=> $now_today["minutes"],
											// // // 'second'=> $now_today["seconds"]
										// // )
									// )
								// ),
								'post_type'=>'storico_coda',
							);
							$ultimo_servito ='';
							while($ultimo_servito==''){
								add_filter( 'posts_where', 'filter_where' );
								$storico_query = new WP_Query( $args );
								remove_filter( 'posts_where', 'filter_where' );
								if ($storico_query->have_posts()){
									$storico_query->the_post();
									$ultimo_servito = the_title();
									echo $ultimo_servito;
									die();
								}
								sleep(1);
							}
							break;
					}
				}
				
				die();
			// }
		}
		} // END class EW_Anti_Code_Management
} // END if(!class_exists('EW_Anti_Code_Management'))