<?php
/**
 * Bootstrap functions and definitions
 *
 * Sets up the theme and provides some helper functions. Some helper functions
 * are used in the theme as custom template tags. Others are attached to action and
 * filter hooks in WordPress to change core functionality.
 *
 *
 * @package WordPress
 * @subpackage WP-Bootstrap
 * @since WP-Bootstrap 0.1
 *
 * Last Updated: September 9, 2012
 */
 
 /*
| -------------------------------------------------------------------
| Richiamo i file di cui ho bisogno
| -------------------------------------------------------------------
|
| */
 
// require('admin/theme-admin.php');
 
 /*
| -------------------------------------------------------------------
| 
| -------------------------------------------------------------------
|
| */

if (!defined('BOOTSTRAPWP_VERSION'))
define('BOOTSTRAPWP_VERSION', '.90');

 /**
 * Declaring the content width based on the theme's design and stylesheet.
 */
if ( ! isset( $content_width ) )
  $content_width = 770; /* pixels */

/*
| -------------------------------------------------------------------
| Setup Theme
| -------------------------------------------------------------------
|
| */
add_action( 'after_setup_theme', 'bootstrapwp_theme_setup' );
if ( ! function_exists( 'bootstrapwp_theme_setup' ) ):
function bootstrapwp_theme_setup() {
  add_theme_support( 'automatic-feed-links' );
  /**
   * Adds custom menu with wp_page_menu fallback
   */
  register_nav_menus( array(
    'main-menu' => __( 'Main Menu', 'bootstrapwp' )
  ) );
  /**
   * Declaring the theme language domain
   */
   load_theme_textdomain('bootstrapwp', get_template_directory() . '/lang');
}
endif;

################################################################################
// Loading All CSS Stylesheets
################################################################################
  function bootstrapwp_css_loader() {
    wp_enqueue_style('bootstrapwp', get_template_directory_uri().'/css/bootstrapwp.css', false ,'0.90', 'all' );
    wp_enqueue_style('prettify', get_template_directory_uri().'/js/google-code-prettify/prettify.css', false ,'1.0', 'all' );
	wp_enqueue_style('style', get_template_directory_uri().'/style.css');
  }
add_action('wp_enqueue_scripts', 'bootstrapwp_css_loader');


################################################################################
// Loading all JS Script Files.  Remove any files you are not using!
################################################################################
  function bootstrapwp_js_loader() {
       wp_enqueue_script('bootstrapjs', get_template_directory_uri().'/js/bootstrap.min.js', array('jquery'),'0.90', true );
	   wp_enqueue_script('dropdown', get_template_directory_uri().'/js/bootstrapwp-hover-dropdown.min.js', array('jquery'),'0.90', true );
       wp_enqueue_script('prettifyjs', get_template_directory_uri().'/js/google-code-prettify/prettify.js', array('jquery'),'1.0', true );
       wp_enqueue_script('demojs', get_template_directory_uri().'/js/bootstrapwp.demo.js', array('jquery'),'0.90', true );
	   wp_enqueue_script('custom', get_template_directory_uri().'/js/custom.js', array('jquery'),'1.0', true );
	   wp_enqueue_script('jscroller', get_template_directory_uri() . '/js/jquery-scroller-v1.min.js');
  }
add_action('wp_enqueue_scripts', 'bootstrapwp_js_loader');


/*
| -------------------------------------------------------------------
| Top Navigation Bar Customization
| -------------------------------------------------------------------

/**
 * Get our wp_nav_menu() fallback, wp_page_menu(), to show a home link.
 */
function bootstrapwp_page_menu_args( $args ) {
  $args['show_home'] = true;
  return $args;
}
add_filter( 'wp_page_menu_args', 'bootstrapwp_page_menu_args' );

/**
 * Get file 'includes/class-bootstrap_walker_nav_menu.php' with Custom Walker class methods
 * */

include 'includes/class-bootstrapwp_walker_nav_menu.php';

/*
| -------------------------------------------------------------------
| Registering Widget Sections
| -------------------------------------------------------------------
| */
function bootstrapwp_widgets_init() {
  register_sidebar( array(
    'name' => 'Page Sidebar',
    'id' => 'sidebar-page',
    'before_widget' => '<div id="%1$s" class="widget %2$s">',
    'after_widget' => "</div>",
    'before_title' => '<h4 class="widget-title">',
    'after_title' => '</h4>',
  ) );

  register_sidebar( array(
    'name' => 'Posts Sidebar',
    'id' => 'sidebar-posts',
    'before_widget' => '<div id="%1$s" class="widget %2$s">',
    'after_widget' => "</div>",
    'before_title' => '<h4 class="widget-title">',
    'after_title' => '</h4>',
  ) );

  register_sidebar(array(
    'name' => 'Home Left',
    'id'   => 'home-left',
    'description'   => 'Left textbox on homepage',
    'before_widget' => '<div id="%1$s" class="widget %2$s">',
    'after_widget'  => '</div>',
    'before_title'  => '<h2>',
    'after_title'   => '</h2>'
  ));

    register_sidebar(array(
    'name' => 'Home Middle',
    'id'   => 'home-middle',
    'description'   => 'Middle textbox on homepage',
    'before_widget' => '<div id="%1$s" class="widget %2$s">',
    'after_widget'  => '</div>',
    'before_title'  => '<h2>',
    'after_title'   => '</h2>'
  ));

    register_sidebar(array(
    'name' => 'Home Right',
    'id'   => 'home-right',
    'description'   => 'Right textbox on homepage',
    'before_widget' => '<div id="%1$s" class="widget %2$s">',
    'after_widget'  => '</div>',
    'before_title'  => '<h2>',
    'after_title'   => '</h2>'
  ));

    register_sidebar(array(
    'name' => 'Footer Content',
    'id'   => 'footer-content',
    'description'   => 'Footer text or acknowledgements',
    'before_widget' => '<div id="%1$s" class="widget %2$s">',
    'after_widget'  => '</div>',
    'before_title'  => '<h4>',
    'after_title'   => '</h4>'
  ));
}
add_action( 'init', 'bootstrapwp_widgets_init' );


/*
| -------------------------------------------------------------------
| Adding Post Thumbnails and Image Sizes
| -------------------------------------------------------------------
| */
if ( function_exists( 'add_theme_support' ) ) {
  add_theme_support( 'post-thumbnails' );
  set_post_thumbnail_size( 160, 120 ); // 160 pixels wide by 120 pixels high
}

if ( function_exists( 'add_image_size' ) ) {
  add_image_size( 'bootstrap-small', 260, 180 ); // 260 pixels wide by 180 pixels high
  add_image_size( 'dueper-medium', 370, 190, true ); // 360 pixels wide by 268 pixels high
  add_image_size( 'large4-squared', 370, 370, true ); // 360 pixels wide by 268 pixels high
  add_image_size( 'home-large', 570, 320, true ); // 360 pixels wide by 268 pixels high
  add_image_size( 'large8', 770, 400, true ); 
  add_image_size( 'button', 300, 150, true ); 
}
/*
| -------------------------------------------------------------------
| Revising Default Excerpt
| -------------------------------------------------------------------
| Adding filter to post excerpts to contain ...Continue Reading link
| */
function bootstrapwp_excerpt($more) {
       global $post;
  return '&nbsp; &nbsp;<a href="'. get_permalink($post->ID) . '">...Continue Reading</a>';
}
add_filter('excerpt_more', 'bootstrapwp_excerpt');


/*
| -------------------------------------------------------------------
| Revising Default Excerpt
| -------------------------------------------------------------------
| Adding filter to post excerpts to contain ...Continue Reading link
| */
function dueper_excerpt_length( $length ) {
	return 21;
}
add_filter( 'excerpt_length', 'dueper_excerpt_length', 999 );




if ( ! function_exists( 'bootstrapwp_content_nav' ) ):
/**
 * Display navigation to next/previous pages when applicable
 */
function bootstrapwp_content_nav( $nav_id ) {
	global $wp_query;

	?>

	<?php if ( is_single() ) : // navigation links for single posts ?>
<ul class="pager">
		<?php previous_post_link( '<li class="previous">%link</li>', '<span class="meta-nav">' . _x( '&larr;', 'Previous post link', 'bootstrapwp' ) . '</span> %title' ); ?>
		<?php next_post_link( '<li class="next">%link</li>', '%title <span class="meta-nav">' . _x( '&rarr;', 'Next post link', 'bootstrapwp' ) . '</span>' ); ?>
</ul>
	<?php elseif ( $wp_query->max_num_pages > 1 && ( is_home() || is_archive() || is_search() ) ) : // navigation links for home, archive, and search pages ?>
<ul class="pager">
		<?php if ( get_next_posts_link() ) : ?>
		<li class="next"><?php next_posts_link( __( '<span class="meta-nav">&larr;</span> Older posts', 'bootstrapwp' ) ); ?></li>
		<?php endif; ?>

		<?php if ( get_previous_posts_link() ) : ?>
		<li class="previous"><?php previous_posts_link( __( 'Newer posts <span class="meta-nav">&rarr;</span>', 'bootstrapwp' ) ); ?></li>
		<?php endif; ?>
</ul>
	<?php endif; ?>

	<?php
}
endif; // bootstrapwp_content_nav


if ( ! function_exists( 'bootstrapwp_comment' ) ) :
/**
 * Template for comments and pingbacks.
 *
 * To override this walker in a child theme without modifying the comments template
 * simply create your own bootstrap_comment(), and that function will be used instead.
 *
 * Used as a callback by wp_list_comments() for displaying the comments.
 *
 * @since WP-Bootstrap .5
 */
function bootstrapwp_comment( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;
	switch ( $comment->comment_type ) :
		case 'pingback' :
		case 'trackback' :
	?>
	<li class="post pingback">
		<p><?php _e( 'Pingback:', 'bootstrap' ); ?> <?php comment_author_link(); ?><?php edit_comment_link( __( '(Edit)', 'bootstrap' ), ' ' ); ?></p>
	<?php
			break;
		default :
	?>
	<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
		<article id="comment-<?php comment_ID(); ?>" class="comment">
			<footer>
				<div class="comment-author vcard">
					<?php echo get_avatar( $comment, 40 ); ?>
					<?php printf( __( '%s <span class="says">says:</span>', 'bootstrap' ), sprintf( '<cite class="fn">%s</cite>', get_comment_author_link() ) ); ?>
				</div><!-- .comment-author .vcard -->
				<?php if ( $comment->comment_approved == '0' ) : ?>
					<em><?php _e( 'Your comment is awaiting moderation.', 'bootstrap' ); ?></em>
					<br />
				<?php endif; ?>

				<div class="comment-meta commentmetadata">
					<a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ); ?>"><time pubdate datetime="<?php comment_time( 'c' ); ?>">
					<?php
						/* translators: 1: date, 2: time */
						printf( __( '%1$s at %2$s', 'bootstrap' ), get_comment_date(), get_comment_time() ); ?>
					</time></a>
					<?php edit_comment_link( __( '(Edit)', 'bootstrap' ), ' ' );
					?>
				</div><!-- .comment-meta .commentmetadata -->
			</footer>

			<div class="comment-content"><?php comment_text(); ?></div>

			<div class="reply">
				<?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
			</div><!-- .reply -->
		</article><!-- #comment-## -->

	<?php
			break;
	endswitch;
}
endif; // ends check for bootstrapwp_comment()


/**
 * Adds custom classes to the array of body classes.
 *
 * @since WP-Bootstrap .5
 */
function bootstrapwp_body_classes( $classes ) {
	// Adds a class of single-author to blogs with only 1 published author
	if ( ! is_multi_author() ) {
		$classes[] = 'single-author';
	}

	return $classes;
}
add_filter( 'body_class', 'bootstrapwp_body_classes' );

/**
 * Returns true if a blog has more than 1 category
 *
 * @since WP-Bootstrap .5
 */
function bootstrapwp_categorized_blog() {
	if ( false === ( $all_the_cool_cats = get_transient( 'all_the_cool_cats' ) ) ) {
		// Create an array of all the categories that are attached to posts
		$all_the_cool_cats = get_categories( array(
			'hide_empty' => 1,
		) );

		// Count the number of categories that are attached to the posts
		$all_the_cool_cats = count( $all_the_cool_cats );

		set_transient( 'all_the_cool_cats', $all_the_cool_cats );
	}

	if ( '1' != $all_the_cool_cats ) {
		// This blog has more than 1 category so bootstrap_categorized_blog should return true
		return true;
	} else {
		// This blog has only 1 category so bootstrap_categorized_blog should return false
		return false;
	}
}

/**
 * Flush out the transients used in bootstrapwp_categorized_blog
 *
 * @since bootstrap 1.2
 */
function bootstrapwp_category_transient_flusher() {
  // Like, beat it. Dig?
  delete_transient( 'all_the_cool_cats' );
}
add_action( 'edit_category', 'bootstrapwp_category_transient_flusher' );
add_action( 'save_post', 'bootstrapwp_category_transient_flusher' );

/**
 * Filter in a link to a content ID attribute for the next/previous image links on image attachment pages
 */
function bootstrapwp_enhanced_image_navigation( $url ) {
	global $post;

	if ( wp_attachment_is_image( $post->ID ) )
		$url = $url . '#main';

	return $url;
}
add_filter( 'attachment_link', 'bootstrapwp_enhanced_image_navigation' );


/*
| -------------------------------------------------------------------
| Checking for Post Thumbnail
| -------------------------------------------------------------------
|
| */
function bootstrapwp_post_thumbnail_check() {
    global $post;
    if (get_the_post_thumbnail()) {
          return true; }
          else { return false; }
}

/*
| -------------------------------------------------------------------
| Setting Featured Image (Post Thumbnail)
| -------------------------------------------------------------------
| Will automatically add the first image attached to a post as the Featured Image if post does not have a featured image previously set.
| */
function bootstrapwp_autoset_featured_img() {

  $post_thumbnail = bootstrapwp_post_thumbnail_check();
  if ($post_thumbnail == true ){
    return the_post_thumbnail();
  }
    if ($post_thumbnail == false ){
      $image_args = array(
                'post_type' => 'attachment',
                'numberposts' => 1,
                'post_mime_type' => 'image',
                'post_parent' => $post->ID,
                'order' => 'desc'
          );
      $attached_image = get_children( $image_args );
             if ($attached_image) {
                                foreach ($attached_image as $attachment_id => $attachment) {
                                set_post_thumbnail($post->ID, $attachment_id);
                                }
            return the_post_thumbnail();
          } else { return " ";}
        }
      }  //end function


/*
| -------------------------------------------------------------------
| Adding Breadcrumbs
| -------------------------------------------------------------------
|
| */
 function bootstrapwp_breadcrumbs() {

  $delimiter = '<span class="divider">/</span>';
  $home = 'Home'; // text for the 'Home' link
  $before = '<li class="active">'; // tag before the current crumb
  $after = '</li>'; // tag after the current crumb

  if ( !is_home() && !is_front_page() || is_paged() ) {

    echo '<ul class="breadcrumb">';

    global $post;
    $homeLink = home_url();
    echo '<li><a href="' . $homeLink . '">' . $home . '</a></li> ' . $delimiter . ' ';

    if ( is_category() ) {
      global $wp_query;
      $cat_obj = $wp_query->get_queried_object();
      $thisCat = $cat_obj->term_id;
      $thisCat = get_category($thisCat);
      $parentCat = get_category($thisCat->parent);
      if ($thisCat->parent != 0) echo(get_category_parents($parentCat, TRUE, ' ' . $delimiter . ' '));
      echo $before . 'Archive by category "' . single_cat_title('', false) . '"' . $after;

    } elseif ( is_day() ) {
      echo '<li><a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a></li> ' . $delimiter . ' ';
      echo '<li><a href="' . get_month_link(get_the_time('Y'),get_the_time('m')) . '">' . get_the_time('F') . '</a></li> ' . $delimiter . ' ';
      echo $before . get_the_time('d') . $after;

    } elseif ( is_month() ) {
      echo '<li><a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a></li> ' . $delimiter . ' ';
      echo $before . get_the_time('F') . $after;

    } elseif ( is_year() ) {
      echo $before . get_the_time('Y') . $after;

    } elseif ( is_single() && !is_attachment() ) {
      if ( get_post_type() != 'post' ) {
        $post_type = get_post_type_object(get_post_type());
        $slug = $post_type->rewrite;
        echo '<li><a href="' . $homeLink . '/' . $slug['slug'] . '/">' . $post_type->labels->singular_name . '</a></li> ' . $delimiter . ' ';
        echo $before . get_the_title() . $after;
      } else {
        $cat = get_the_category(); $cat = $cat[0];
        echo get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
        echo $before . get_the_title() . $after;
      }

    } elseif ( !is_single() && !is_page() && get_post_type() != 'post' && !is_404() ) {
      $post_type = get_post_type_object(get_post_type());
      echo $before . $post_type->labels->singular_name . $after;

    } elseif ( is_attachment() ) {
      $parent = get_post($post->post_parent);
      $cat = get_the_category($parent->ID); $cat = $cat[0];
      echo get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
      echo '<li><a href="' . get_permalink($parent) . '">' . $parent->post_title . '</a></li> ' . $delimiter . ' ';
      echo $before . get_the_title() . $after;

    } elseif ( is_page() && !$post->post_parent ) {
      echo $before . get_the_title() . $after;

    } elseif ( is_page() && $post->post_parent ) {
      $parent_id  = $post->post_parent;
      $breadcrumbs = array();
      while ($parent_id) {
        $page = get_page($parent_id);
        $breadcrumbs[] = '<li><a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a></li>';
        $parent_id  = $page->post_parent;
      }
      $breadcrumbs = array_reverse($breadcrumbs);
      foreach ($breadcrumbs as $crumb) echo $crumb . ' ' . $delimiter . ' ';
      echo $before . get_the_title() . $after;

    } elseif ( is_search() ) {
      echo $before . 'Search results for "' . get_search_query() . '"' . $after;

    } elseif ( is_tag() ) {
      echo $before . 'Posts tagged "' . single_tag_title('', false) . '"' . $after;

    } elseif ( is_author() ) {
       global $author;
      $userdata = get_userdata($author);
      echo $before . 'Articles posted by ' . $userdata->display_name . $after;

    } elseif ( is_404() ) {
      echo $before . 'Error 404' . $after;
    }

    if ( get_query_var('paged') ) {
      if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ' (';
      echo __('Page', 'bootstrapwp') . ' ' . get_query_var('paged');
      if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
    }

    echo '</ul>';

  }
} // end bootstrapwp_breadcrumbs()


/*
| --------------------------------------------------------------------------------------------------------------------------------------
| 
|
|										Qui inizia Dueper
|
|
| --------------------------------------------------------------------------------------------------------------------------------------
|
| */

/*
| -------------------------------------------------------------------
| Rimuovo avviso di upgrade nel backend
| -------------------------------------------------------------------
|
| */

add_action('admin_menu','wphidenag');
function wphidenag() {
remove_action( 'admin_notices', 'update_nag', 3 );
}



/*
| -------------------------------------------------------------------
| Personalizzo URL del Logo nella pagina di login
| -------------------------------------------------------------------
|
| */


add_filter( 'login_headerurl', 'my_custom_login_url' );
function my_custom_login_url($url) {
	$siteURL = get_bloginfo('url');
	return $siteURL;
}



/*
| -------------------------------------------------------------------
| Personalizzo Logo nella pagina di login
| -------------------------------------------------------------------
|
| */

function dueper_custom_loginlogo() {
echo '<style type="text/css">
h1 a {background-image: url('.get_bloginfo('template_directory').'/img/login-logo.png) !important;
}
.login form {
	animation: jump 1s 1;
	-webkit-animation: jump 1s 1;
	-moz-animation: jump 1s 1;
	-ms-animation: jump 1s 1;
}

@keyframes jump {
    0% {
        margin-top:800px;
    }
	100% {
        margin-top:0px;
    }
}
@-webkit-keyframes jump {
    0% {
        margin-top:800px;
    }
	100% {
        margin-top:0px;
    }
}
@-moz-keyframes jump {
    0% {
        margin-top:800px;
    }
	100% {
        margin-top:0px;
    }
}
@-ms-keyframes jump {
    0% {
        margin-top:800px;
    }
	100% {
        margin-top:0px;
    }
}
</style>';
}
add_action('login_head', 'dueper_custom_loginlogo');




/*
| -------------------------------------------------------------------
| Personalizzo Logo nel back-end di wordpress
| -------------------------------------------------------------------
|
| */

add_action('admin_head', 'dueper_admin_custom_logo');
add_action('wp_head', 'dueper_admin_custom_logo');

function dueper_admin_custom_logo() {
echo '
<style type="text/css">
#wp-admin-bar-wp-logo { display:none !important; }
#wp-admin-bar-site-name > .ab-item { text-indent: -9999px; background-image: url('.get_bloginfo('template_directory').'/img/custom-admin-logo.png) !important; background-position:center !important; background-color:none !important; background-repeat: no-repeat !important; width:112px; height:auto !important;  }
wp-admin-bar-site-name > .ab-item:hover { background-color:none !important;}
#wp-admin-bar-site-name.hover > .ab-item { background-image: url('.get_bloginfo('template_directory').'/img/custom-admin-logo-hover.png) !important; background-position:center !important; background-repeat: no-repeat !important;}
</style>
';
}


/*
| -------------------------------------------------------------------
| Personalizzo Footer nel back-end di wordpress
| -------------------------------------------------------------------
|
| */

function remove_footer_admin () {
echo 'Creato a partire da <a href="http://www.wordpress.org" target="_blank">WordPress</a> | ' . get_option('dueper_footer_text') .'</p>';
}

add_filter('admin_footer_text', 'remove_footer_admin');



/*
| -------------------------------------------------------------------
| Disabilito widget nella dashboard di wordpress
| -------------------------------------------------------------------
|
| */

function dueper_remove_dashboard_widgets() {
	global $wp_meta_boxes;

	unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_quick_press']); // disabilito quick press nella dashboard
	unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_incoming_links']); // disabilito Link in entrata nella dashboard
	//unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_right_now']); // disabilito Riassunto sito (numero di post/commenti ecc..) nella dashboard
	unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_plugins']); // disabilito widget plugin nella dashboard
	unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_recent_drafts']); // disabilito widget Bozze recenti nella dashboard
	unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_recent_comments']); // disabilito widget dei commenti recenti nella dashboard
	unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_primary']); // disabilito widget Wordpress Blog nella dashboard
	unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_secondary']); // disabilito widget Other Wordpress news nella dashboard

}

add_action('wp_dashboard_setup', 'dueper_remove_dashboard_widgets' );




/*
| -------------------------------------------------------------------
| Aggiungo widget personalizzato nel back-end di wordpress
| -------------------------------------------------------------------
|
| */

add_action('wp_dashboard_setup', 'dueper_dashboard_widgets');

function dueper_dashboard_widgets() {
global $wp_meta_boxes;
wp_add_dashboard_widget('dueper_help_widget', 'Hai bisogno di aiuto?', 'dueper_dashboard_help');
}

function dueper_dashboard_help() {
echo '<p><h2>Hai riscontrato dei problemi che non rieci a risolvere?</h2><br /><a href="http://www.dueper.net" target="_blank" class="button button-primary button-large">Contattaci</a></p>';
}

/* ---  Servizi --- */


add_action('wp_dashboard_setup', 'servizi_dashboard_widgets');

function servizi_dashboard_widgets() {
global $wp_meta_boxes;
wp_add_dashboard_widget('servizi_help_widget', 'Servizi Erogati', 'servizi_dashboard_help');
}

function servizi_dashboard_help() {
echo '<p><a href="'. admin_url() .'/edit.php?post_type=servizi" class="button button-primary button-large">Gestisci i Servizi</a></p>';
}


/* ---  Sportelli --- */


add_action('wp_dashboard_setup', 'sportelli_dashboard_widgets');

function sportelli_dashboard_widgets() {
global $wp_meta_boxes;
wp_add_dashboard_widget('sportelli_help_widget', 'Sportelli', 'sportelli_dashboard_help');
}

function sportelli_dashboard_help() {
echo '<p><a href="'. admin_url() .'/edit.php?post_type=sportelli" class="button button-primary button-large">Gestisci gli Sportelli</a></p>';
}

/*
| -------------------------------------------------------------------
| Setto avatar standard
| -------------------------------------------------------------------
|
| */

add_filter( 'avatar_defaults', 'dueper_newgravatar' );

function dueper_newgravatar ($avatar_defaults) {
$myavatar = get_bloginfo('template_directory') . '/img/gravatar1.png'; //inserire nella cartella /img/ la png
$avatar_defaults[$myavatar] = get_current_theme();
return $avatar_defaults;
}



// rimuovo informazioni
add_filter('user_contactmethods','dueper_hide_profile_fields',10,1);

function dueper_hide_profile_fields( $contactmethods ) {
unset($contactmethods['aim']);
unset($contactmethods['jabber']);
unset($contactmethods['yim']);
return $contactmethods;
}

// aggiungo nuove informazioni
function dueper_new_contact_methods( $contactmethods ) {
// Add Twitter
$contactmethods['twitter'] = 'Twitter';
//add Facebook
$contactmethods['facebook'] = 'Facebook';
//add Facebook
$contactmethods['youtube'] = 'Youtube';

return $contactmethods;
}
add_filter('user_contactmethods','dueper_new_contact_methods',10,1);


/*
| -------------------------------------------------------------------
| Aggiungo Immagine copertnina nei feed RSS
| -------------------------------------------------------------------
|
| */

function dueper_rss_post_thumbnail($content) {
global $post;
if(has_post_thumbnail($post->ID)) {
$content = '<p>' . get_the_post_thumbnail($post->ID) .
'</p>' . get_the_content();
}
return $content;
}
add_filter('the_excerpt_rss', 'dueper_rss_post_thumbnail');
add_filter('the_content_feed', 'dueper_rss_post_thumbnail');



/*
| -------------------------------------------------------------------
| Regolo la compressione delle immagini 
| (valore fornito nel pannello del tema nel backend)
| -------------------------------------------------------------------
|
| */
function dueper_qualita(){
	$compressione = get_option('dueper_compressione_jpeg'); // assegno alla compressione il valore settato nel pannello del tema nel backend 
	return $compressione;
	}

add_filter('jpeg_quality', 'dueper_qualita' );


/*
| -------------------------------------------------------------------
| Sostituisco Howdy con un testo custom
| (valore fornito nel pannello del tema nel backend)
| -------------------------------------------------------------------
|
| */

add_action( 'admin_bar_menu', 'wp_admin_bar_my_custom_account_menu', 11 );

function wp_admin_bar_my_custom_account_menu( $wp_admin_bar ) {
$user_id = get_current_user_id();
$current_user = wp_get_current_user();
$profile_url = get_edit_profile_url( $user_id );

if ( 0 != $user_id ) {
/* Add the "My Account" menu */
$avatar = get_avatar( $user_id, 28 );
$howdy = sprintf( __('YO! %1$s'), $current_user->display_name );
$class = empty( $avatar ) ? '' : 'with-avatar';

$wp_admin_bar->add_menu( array(
'id' => 'my-account',
'parent' => 'top-secondary',
'title' => $howdy . $avatar,
'href' => $profile_url,
'meta' => array(
'class' => $class,
),
) );

}
}


/*
| -------------------------------------------------------------------
|Aggiungo una colonna custom nella tabella dei post
| -------------------------------------------------------------------
|
*/
function servizi_column ($columns) {
  	$columns['servizi_column'] = __('Servizi erogati','servizi-erogati');
  	return $columns;
}
add_filter ('manage_sportelli_posts_columns', 'servizi_column',10,2);



/*
| -------------------------------------------------------------------
|Riempio la colonna con i dati
| -------------------------------------------------------------------
|
*/
function servizi_value ($column_name) {
	global $post;
	$id = $post->ID;
	if ($column_name === 'servizi_column') {
		$posts = get_field('servizi_erogati');
 
		if( $posts ): ?>
			<?php foreach( $posts as $post): // variable must be called $post (IMPORTANT) ?>
				<?php setup_postdata($post); ?>
				<strong><?php the_title(); ?></strong>&nbsp;-
			<?php endforeach; ?>
			<?php wp_reset_postdata(); // IMPORTANT - reset the $post object so the rest of the page works correctly ?>
		<?php endif;
		
  	}
}
add_action ('manage_sportelli_posts_custom_column', 'servizi_value');



@ini_set( 'upload_max_size' , '64M' );
@ini_set( 'post_max_size', '64M');
@ini_set( 'max_execution_time', '300' );