<?php
/**
 * Template Name: Stampa Biglietto
 * Description: Page template to display blog posts
 *
 * @package WordPress
 * @subpackage WP-Bootstrap
 * @since WP-Bootstrap 0.1
 */

if(class_exists('EW_Anti_Code')){
	$ew_anti_code = new EW_Anti_Code();
	// embed the javascript file that makes the AJAX request
	wp_enqueue_script( 'my-ajax-request', $ew_anti_code->plugin_dir_url( ) . 'js/ajax.js', array( 'jquery' ) );
	}
 
// declare the URL to the file that handles the AJAX request (wp-admin/admin-ajax.php)
wp_localize_script( 'my-ajax-request', 'MyAjax', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ) ) );


get_header(); 

?>


<div class="container nav-margin">
     <div role="navigation" class="navbar">
         <div class="navbar-inner">
                <!-- .btn-navbar is used as the toggle for collapsed navbar content -->
                <button type="button" class="btn btn-navbar" data-toggle="collapse" data-target=".secondo">
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </button>
                    <?php
                    wp_nav_menu( array(
                            'menu'            => 'main-menu',
                              'menu_class'      => 'nav',
							  'container_class' => 'nav-collapse secondo',
                              'fallback_cb'     => '',
                              'menu_id' => 'main-menu',
                              'walker' => new Bootstrapwp_Walker_Nav_Menu()
                        )
                    );
                    ?>
           </div><!-- .navbar-inner -->
        </div>
        </div>

<?php if ( have_posts() ) : the_post(); ?>

<div class="container-fluid">    
    <div class="row-fluid content">
        <div class="span12 text-center" id="content">
            
            <!-- Inserisco contenuto-->
            <form method="post" action="">
            
            <ul class="nav nav-tabs text-center">
				<?php
                $args = array(
                    'post_status' => 'publish',
					'order'           => 'ASC',
                    'post_type' => 'sportelli'
                ); 
                $sportelli = get_posts($args);
                //per ogni servizio stampa
                foreach ( $sportelli as $sportello ) :
                    $id_sportello = $sportello->ID;
                    $titolo_sportello = $sportello->post_title;
                ?>		
                <li><a href="#pane_<?php echo $id_sportello; ?>" data-toggle="tab"><?php echo $titolo_sportello; ?></a></li>
                <?php endforeach; ?>
            </ul>
            
			<?php
            // if ( function_exists('wp_nonce_field') ) wp_nonce_field($this->referer_check_key);
            ?>
            <div class="tab-content">
            <?php
            $args = array(
                'post_status' => 'publish',
                'post_type' => 'sportelli'
            ); 
            $sportelli = get_posts($args);
            //per ogni servizio stampa
            foreach ( $sportelli as $sportello ) {
                $id_sportello = $sportello->ID;
                $titolo_sportello = $sportello->post_title;
            ?>
            <div class="tab-pane" id="pane_<?php echo $id_sportello; ?>">
                <h2><?php echo $titolo_sportello; ?></h2>
                gestisce:
                <?php
                    $servizi_erogati = get_field('servizi_erogati', $id_sportello);
                    if( $servizi_erogati ){
                        foreach( $servizi_erogati as $servizio_erogato){
                            $sigla_servizio = get_post_meta($servizio_erogato->ID, 'sigla_servizio', true);
                            echo "$sigla_servizio ,";
                        }
                    }
                ?>
                <hr class="small" />
                <li class="sportello btn btn-large" id="sportello_<?php echo $id_sportello; ?>" name="sportello" value="<?php echo $id_sportello; ?>">
                    <span class="entypo">&oplus;</span>&nbsp;&nbsp;<?php echo $titolo_sportello; ?>
                </li>
                <hr/>
            </div><!-- tab-bane -->
            <?php		}?>
			
            </div><!--tab-content-->
            
            <!--
				<input type="hidden" name="esegui" id="esegui" value="niente">
                <input type="button" name="submit" id="submit" onclick="document.getElementById('esegui').value='stampa_biglietto';" value="Stampa il biglietto!">
            -->
			</form>
			<hr />
            <div class="ultimo-servito-container">Ultimo Servito:<label class="lead" id='label_ultima_servito'></label>
            </div>
            
            <div class="reset_code btn btn-large btn-danger" id="reset_code">Reset Code!</div>
            
        </div><!-- /.span12 -->
    
    </div><!--row-->
</div><!--container-->
<?php endif; ?>
<?php get_footer(); ?>