﻿<?php
/**
 * Template Name: Output Monitor
 * Description: Page template to display blog posts
 *
 * @package WordPress
 * @subpackage WP-Bootstrap
 * @since WP-Bootstrap 0.1
 */
if(class_exists('EW_Anti_Code')){
	$ew_anti_code = new EW_Anti_Code();
	// embed the javascript file that makes the AJAX request
	wp_enqueue_script( 'my-ajax-request', $ew_anti_code->plugin_dir_url( ) . 'js/ajax.js', array( 'jquery' ) );
	}

// declare the URL to the file that handles the AJAX request (wp-admin/admin-ajax.php)
wp_localize_script( 'my-ajax-request', 'MyAjax', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ) ) );
 ?>
<?php
get_header('clean');
 ?>

 <script type="text/javascript">

	function update_storico()
	{
		 jQuery.ajax({
			url: MyAjax.ajaxurl,
			type: 'POST',
			data: {
				action:				'ajax_plugin_management',					// The function located in plugin.php for handling the request
				//nonce: 				$('#ajax_post_author_credit_nonce').text(),	// The security nonce
				esegui:				'ultimo_storico2'
			},
			success: function(response) {
				var elementi_response=response.split("-");
				var id_sportello = elementi_response[0];
				var ultimo_numero = elementi_response[1];
				var contenuto = jQuery("#Sportello_"+id_sportello).text();
				if( contenuto != ultimo_numero){
					jQuery("#Sportello_"+id_sportello).text(ultimo_numero);
					jQuery("#Sportello_"+id_sportello).removeClass("update_red");
					jQuery("#Sportello_"+id_sportello).addClass("update_red");
					jQuery("#Sportello_"+id_sportello).fadeOut();
					jQuery("#Sportello_"+id_sportello).fadeIn();
					jQuery("#Sportello_"+id_sportello).fadeOut();
					jQuery("#Sportello_"+id_sportello).fadeIn();
					/*jQuery("#Sportello_"+id_sportello).css({ color: "#f00" });
					setTimeout(function(){
						jQuery("#Sportello_"+id_sportello).animate({color: "#f0f"})
						},5000);*/

					// var beepOne = jQuery("#beep-one")[0];
						// beepOne.play();



					if (typeof jQuery("#beep"+id_sportello)[0]  != 'undefined') {
						jQuery("#beep"+id_sportello)[0].play();
					}

				}
			},
			complete: function(){
				update_storico();
			},
			timeout: 240000
		});
		 // jQuery("#Sportello_"+id_sportello).text("Sportelo "+id_sportello);

	}

	// update_storico();
	setTimeout("update_storico();", 10000 );
 </script>


<script>
function startTime()
{
	var today=new Date();
	var h=today.getHours();
	var m=today.getMinutes();
	// add a zero in front of numbers<10
	m=checkTime(m);
	document.getElementById('txt').innerHTML=h+":"+m;
	t=setTimeout(function(){startTime()},500);
}

function checkTime(i)
{
	if (i<10)
	  {
	  i="0" + i;
	  }
	return i;
}
</script>


<?php if ( have_posts() ) : the_post(); ?>

<div class="ora">
	<div id="txt"></div>
</div>

<div class="container-fluid">
    <div class="row-fluid content">
    	<div class="span8">
        	<div class="video-container">
            	<?php $video = get_field('video','option'); ?>
        		<video src="<?php echo $video; ?>" width="1800" autoplay="autoplay" muted="true" loop="loop"></video>
            </div><!--video-container-->
        </div>
        <div class="span4" id="content">

            <!-- Inserisco contenuto-->
            <div class="sportello-outer logo">
                <div class="sportello-inner">
                    <div class="text-center">
                        <?php $image = wp_get_attachment_image( 36756, 'large2-tall' ); 
		echo $image; ?>
                    </div><!--text-center-->
                </div>
            </div>

			<?php

			$args = array(
			'post_status' => 'publish',
			'post_type' => 'sportelli',
			'orderby'         => 'title',
			'order'           => 'ASC',
			);
			$sportelli = get_posts($args);
			//per ogni storico coda
			foreach ( $sportelli as $sportello ) :
				$id_sportello = $sportello->ID;
				$titolo_sportello = $sportello->post_title;
				?>
				<div class="sportello-outer">
                <div class="titolo-sportello"><?php echo $titolo_sportello;?></div>
				<?php
				$args = array(
				'post_status' => 'publish',
				'post_type' => 'storico_coda',
				'orderby'         => 'post_date',
				'order'           => 'DESC',
				'meta_key'        => 'sportello',
				'meta_value'      => $id_sportello,
				'posts_per_page'  => 1
				);
				$storico_coda = get_posts($args);
				//per ogni storico coda
				foreach ( $storico_coda as $storico ) :
					$id_storico = $storico->ID;
					$titolo_storico = $storico->post_title;
					$Storico_data = $storico->post_modified_gmt ;
		?>

				<div class="sportello-inner" type="radio" id="Sportello_<?php echo $titolo_sportello; ?>" name="storico" value="<?php echo $id_sportello; ?>">
				<?php echo get_field('ultimo_servito', $id_sportello); ?>
				</div>
    		<audio id="beep<?php echo $titolo_sportello; ?>" controls="controls" preload="auto">
				<source src="<?php echo home_url(); ?>/wp-content/uploads/2013/07/Sound.mp3">
			</audio>
				<?php endforeach; ?>
			</div>
			<?php endforeach; ?>
            <div class="sportello-outer attesa">
                <div class="sportello-inner">
                Tempo di attesa stimato
                <h1 class="blue">7 minuti</h1>
                </div>
            </div>
        </div><!-- /.span12 -->




    </div><!--row-->
    <div class="row-fluid content">
    	<div class="span12 piedino">
        	<?php if (get_field('attivare_messaggio','option')): ?>
        	<div class="scrollingtext lead"><?php the_field('messaggio','option'); ?></div>
            <?php endif; ?>
        </div>
    </div>
</div><!--container-->
<?php endif; ?>
<?php get_footer(); ?>
