<?php
/**
 * Template Name: Scelta sportello
 * Description: Page template to display blog posts
 *
 * @package WordPress
 * @subpackage WP-Bootstrap
 * @since WP-Bootstrap 0.1
 */


if(class_exists('EW_Anti_Code')){
	$ew_anti_code = new EW_Anti_Code();
	// embed the javascript file that makes the AJAX request
	wp_enqueue_script( 'my-ajax-request', $ew_anti_code->plugin_dir_url( ) . 'js/ajax.js', array( 'jquery' ) );
	}
 
// declare the URL to the file that handles the AJAX request (wp-admin/admin-ajax.php)
wp_localize_script( 'my-ajax-request', 'MyAjax', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ) ) );

get_header(); ?>
<?php if ( have_posts() ) : the_post(); ?>


<div class="container-fluid">    
    <div class="row-fluid content">
        <div class="span12 text-center">
            <!-- Inizio: pulsanti sportelli------------------------------------------>
            <?php
            $args = array(
                'post_status' => 'publish',
				'order'           => 'ASC',
                'post_type' => 'sportelli'
            );
            query_posts( $args );
                
            if (have_posts()) : ?>
            <span class="entypo large gray">&#128100;</span>
            <p class="lead">Selezionare lo sportello da gestire</p>
            <?php while ( have_posts() ) : the_post(); ?>
                  <div class="row-fluid">
                    <div class="span12">
                        <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" class="btn btn-maxi margin-bottom" onclick="window.open(this.href, 'mywin',
'left=20,top=20,width=250,height=500,toolbar=1,resizable=0'); return false;" >Sportello <?php the_title(); ?> <span class="entypo">&#59230;</span></a>
            
                    </div><!-- /.span12 -->
                 </div><!-- /.row -->
			 <?php endwhile; ?>
             <?php endif; ?>
             <!-- Fine: pulsanti sportelli------------------------------------------>
             
             <!-- Inizio: pulsanti biglietti------------------------------------------>
             <div class="bg-gray">
             <?php $permalink = get_permalink( '24' );
			 $admin_url = admin_url(); ?>
             <span class="entypo large gray">&#128187;</span> 
             <p class="lead">Gestione monitor attesa</p>
                 <div class="row-fluid">
                    <div class="span12">
                        <a href="<?php echo $admin_url; ?>/admin.php?page=acf-options" class="btn btn-large margin-bottom"><span class="entypo medium">&#9881;</span> Pagina Opzioni</a>
                    </div><!--span12-->
                 </div><!--row-fluid-->
                 <div class="row-fluid">
                    <div class="span12">
             			<a href="<?php echo $permalink; ?>" target="_blank" class="btn btn-primary btn-large margin-bottom"><span class="entypo medium">&#59146;</span> Anteprima Monitor</a>
                   </div><!--span12-->
                 </div><!--row-fluid-->
             </div><!--bg-gray-->
             <!-- Fine: pulsanti biglietti------------------------------------------>
             <!-- Inizio: pulsanti biglietti------------------------------------------>
             <?php $pc_permalink = get_permalink( '22' ); ?>
             <span class="entypo large gray">&#127915;</span> 
             <p class="lead">Gestione biglietti prenotazione</p>
                 <div class="row-fluid">
                    <div class="span12">
                        <a href="<?php echo $admin_url; ?>edit.php?post_type=servizi" class="btn btn-large margin-bottom"><span class="entypo medium">&#9881;</span> Gestisci servizi e bottoni</a>
                    </div><!--span12-->
                 </div><!--row-fluid-->
                 <div class="row-fluid">
                    <div class="span12">
             			<a href="<?php echo $pc_permalink; ?>" target="_blank" class="btn btn-primary btn-large margin-bottom"><span class="entypo medium">&#59146;</span> Anteprima PC Prenotazione</a>
                   </div><!--span12-->
                 </div><!--row-fluid-->
             <!-- Fine: pulsanti biglietti------------------------------------------>
             
             <!-- Inizio: pulsanti refresh------------------------------------------>
             <div class="bg-gray">
             <span class="entypo large gray">&#59177;</span> 
             <p class="lead">Reset totale delle Code</p>
                 <div class="row-fluid">
                    <div class="span12">
                        <div id="reset_code" class="btn btn-danger btn-large margin-bottom reset_code"><span class="entypo medium">&#10006;</span> Reset</div>
                    </div><!--span12-->
                 </div><!--row-fluid-->
             </div><!--bg-gray-->
             <!-- Fine: pulsanti refresh------------------------------------------>
                
            <div class="content-alert">
            <div id="reset_code_ok" class="reset_code_ok alert alert-block alert-error fade in">
                <!--<button type="button" class="close" data-dismiss="alert">×</button>-->
                <h4 class="alert-heading">Il Reser delle Code è avvenuto con successo</h4>
                <p>Ora la numerazione dei servizi ricomiciera da capo.</p>
            </div>   
            </div>
                
             
        </div><!-- /.span12 -->
    </div><!--row-->
</div><!--container-->
<?php endif; ?>
<?php get_footer(); ?>