<?php
/**
 * Template Name: Stampa Biglietto
 * Description: Page template to display blog posts
 *
 * @package WordPress
 * @subpackage WP-Bootstrap
 * @since WP-Bootstrap 0.1
 */

if(class_exists('EW_Anti_Code')){
	$ew_anti_code = new EW_Anti_Code();
	// embed the javascript file that makes the AJAX request
	wp_enqueue_script( 'my-ajax-request', $ew_anti_code->plugin_dir_url( ) . 'js/ajax.js', array( 'jquery' ) );
	}

// declare the URL to the file that handles the AJAX request (wp-admin/admin-ajax.php)
wp_localize_script( 'my-ajax-request', 'MyAjax', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ) ) );


get_header('big');

?>

<script>

	// disabilita tasto dx

	if (top.frames.length != 0)
	{
	top.location = self.document.location;
	}

	var omitformtags=["input", "textarea", "select"]

	omitformtags=omitformtags.join("|")

	function disableselect(e){
	if (omitformtags.indexOf(e.target.tagName.toLowerCase())==-1)
	return false
	}

	function reEnable(){
	return true
	}

	if (typeof document.onselectstart!="undefined")
	document.onselectstart=new Function ("return false")
	else{
	document.onmousedown=disableselect
	document.onmouseup=reEnable
	}

	var mes="";

	function clickIE()  {if (document.all) {alert(mes);return false;}}
	function clickNS(e) {if
	(document.layers||(document.getElementById&&!document.all)) {
	}}
	if (document.layers)
	{document.captureEvents(Event.MOUSEDOWN);document.onmousedown=clickNS;}
	else{document.onmouseup=clickNS;document.oncontextmenu=clickIE;}

	document.oncontextmenu=new Function("return false")

</script>

<?php if ( have_posts() ) : the_post(); ?>

<div id="overlay-stampa">
	<div class="overlay-content">

        <div class="text"><h2 class="blue">Stampa in corso</h2>
        <img src="<?php bloginfo( 'template_url' ); ?>/img/stampaincorso.gif" />
        </div>

    </div>
</div>

<div class="container-fluid text-center">

    <div class="row-fluid content text-center">
        <h2>Seleziona il servizio desiderato</h2>
        <hr />
    </div><!--row-->
</div>
<div class="container-fluid text-center stampa">
    <div class="row-fluid content text-center">
        <!-- Inserisco contenuto-->
        <form method="post" action="">

            <?php
            // if ( function_exists('wp_nonce_field') ) wp_nonce_field($this->referer_check_key);
            ?>
            <?php
                $args = array(
                'post_status' => 'publish',
                'post_type' => 'servizi',
				'posts_per_page'=>-1
                );
                $servizi = get_posts($args);
                //per ogni servizio stampa
				$i=0;
                foreach ( $servizi as $servizio ) {
                    $id_servizio = $servizio->ID;
                    $titolo_servizio = $servizio->post_title;
                    $post_type = $servizio->post_type;
                    $sigla_servizio = $servizio->sigla_servizio;
                    $ultimo_stampato = $servizio->ultimo_stampato;
                    $ultimo_servito = $servizio->ultimo_servito;
                    $pulsante_servizio = $servizio->testo_pulsante_servizio;
                    if ($pulsante_servizio=="")$pulsante_servizio=$titolo_servizio;
            ?>
                <li class="servizio btn btn-maxi span12" id="servizio_<?php echo $id_servizio; ?>" name="servizio" value="<?php echo $id_servizio; ?>" style="border:none; background-color:<?php the_field('colore_servizio',$id_servizio); ?>;">
                	<div class="row">
                    	<div class="span6 button-container">
                        	<div class="contenuto">
							<?php $icona=get_field('icona_servizio',$id_servizio); ?>
                            <?php echo wp_get_attachment_image( $icona, 'button',false,array('class'=>'img-button') ); ?>
                        	</div>
                        </div>
                        <div class="span6 button-container">
                        	<div class="contenuto">
                        	<?php echo $pulsante_servizio; ?> <!-- Servizio: <?php echo $titolo_servizio; ?> (<?php echo $sigla_servizio; ?>)  stampati: <?php echo $ultimo_stampato;?>, serviti: <?php echo $ultimo_servito;?>-->
                            </div>
                		</div>
                    </div>
                </li>
                </div>
				<div class='row-fluid'>

            <?php		}?>

        <!--
            <input type="hidden" name="esegui" id="esegui" value="niente">
            <input type="button" name="submit" id="submit" onclick="document.getElementById('esegui').value='stampa_biglietto';" value="Stampa il biglietto!">
        -->
        </form>
     </div><!--row-->

</div>
<iframe id="iframeprint" width="0" height="0" style="width:0;height:0;border:0" frameborder="1" src="/aa"></iframe>

<?php /*?><div class="container-fluid text-center">
     <div class="row-fluid">
         <div class="span12">
            <p class="lead">Stampa in corso di <div id='label_ultima_stampa' class='numero-stampato'></div></p>
         </div><!--span12-->
    </div><!--row-->
</div><!--container--><?php */?>
<?php endif; ?>
<?php get_footer('clean'); ?>
