<?php
/**
 * The template for displaying all posts.
 *
 * Default Post Template
 *
 * Page template with a fixed 940px container and right sidebar layout
 *
 * @package WordPress
 * @subpackage WP-Bootstrap
 * @since WP-Bootstrap 0.1
 */
if(class_exists('EW_Anti_Code')){
	$ew_anti_code = new EW_Anti_Code();
	// embed the javascript file that makes the AJAX request
	wp_enqueue_script( 'my-ajax-request', $ew_anti_code->plugin_dir_url( ) . 'js/ajax.js', array( 'jquery' ) );
	}
 
// declare the URL to the file that handles the AJAX request (wp-admin/admin-ajax.php)
wp_localize_script( 'my-ajax-request', 'MyAjax', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ) ) );
?>

<?php
get_header('clean'); ?>
 <script type="text/javascript">
	function numeri_mancanti(id_servizio) 
	{ 
		 jQuery.post(MyAjax.ajaxurl, {
			action:				'ajax_plugin_management',					// The function located in plugin.php for handling the request
			//nonce: 				$('#ajax_post_author_credit_nonce').text(),	// The security nonce
			esegui:				'mancanti_servizio',					//$('#esegui').val(),
			servizio: 			id_servizio
		}, function(response) {
			jQuery("#mancanti_servizio_"+id_servizio).text(response);
		});
		 
	} 
	function numeri_mancanti2() 
	{ 
		jQuery.ajax({
			url: MyAjax.ajaxurl,
			type: 'POST',
			data: {
				action:				'ajax_plugin_management',					// The function located in plugin.php for handling the request
				//nonce: 				$('#ajax_post_author_credit_nonce').text(),	// The security nonce
				esegui:				'mancanti_servizio2',					//$('#esegui').val()
			},
			success: function(response) {
				var elementi_response=response.split("-");
				var id_servizio = elementi_response[0];
				var numeri_mancanti = elementi_response[1];
				jQuery("#mancanti_servizio_"+id_servizio).text(numeri_mancanti);
			},
			complete: function(){
				numeri_mancanti2();
			},
			timeout: 240000 
		});
	}
	numeri_mancanti2();
 </script>
<?php while ( have_posts() ) : the_post(); ?>
<div class="container-fluid">
    <div class="row-fluid">
    	<div class="span12 text-center">
        	<h4>Sportello: <?php the_title();?></h4>
			<strong>Servizi erogati</strong>
			<?php
				$servizi_erogati = get_field('servizi_erogati', $id_sportello);
				if( $servizi_erogati ){
					echo "<ul>";
					foreach( $servizi_erogati as $servizio_erogato){
						$sigla_servizio = get_post_meta($servizio_erogato->ID, 'sigla_servizio', true);
						// $numeri_mancanti= $ew_anti_code->numeri_mancanti($servizio_erogato->ID);
						$ultimo_servito = get_field('ultimo_servito', $servizio_erogato->ID);
						$ultimo_stampato = get_field('ultimo_stampato', $servizio_erogato->ID);
						$numeri_mancanti = $ultimo_stampato - $ultimo_servito;
						?>

						<li class="rimanenti">coda: <span class="lead"><?php echo $sigla_servizio;?></span> - rimanenti <span class="numero" id="mancanti_servizio_<?php echo $servizio_erogato->ID;?>"><?php echo $numeri_mancanti;?></span></li>
						<?php
						// echo "<li>$servizio_erogato->post_title; ($sigla_servizio)<span></span></li>";
					}
					echo "</ul>";
				}
			?>
			<?php edit_post_link('Modifica i servizi gestiti da questo sportello','<span class="btn btn-danger white">','</span>'); ?>
			<hr />
			<h4>Avanza</h4>
			<li class="sportello entypo large btn btn-avanza" id="sportello_<?php echo the_ID(); ?>" name="sportello" value="<?php echo the_ID();; ?>">
			&oplus;
			</li>
			<hr />
			<h4>Numero Chiamato</h4>
			<div class="ultimo-servito-container"><label class="lead" id='label_ultima_servito'></label></div>
            <hr />
            
        </div><!--span12-->
    </div><!-- .row content -->
</div><!--container-->
<?php endwhile; // end of the loop. ?>
<?php get_footer('clean'); ?>